(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     69230,       1799]*)
(*NotebookOutlinePosition[     70729,       1842]*)
(*  CellTagsIndexPosition[     70685,       1838]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["Integrales de l\[IAcute]nea. Campos conservativos", "Title"],

Cell["\<\
Francisco Javier P\[EAcute]rez Gonz\[AAcute]lez
Departamento de An\[AAcute]lisis Matem\[AAcute]tico
Universidad de Granada
\
\>", "Author",
  TextAlignment->Right,
  FontSize->12],

Cell[CellGroupData[{

Cell["Integrales de l\[IAcute]nea y campos conservativos", "Section"],

Cell[CellGroupData[{

Cell["Ejercicio 1", "Exercise"],

Cell["\<\
1) Define comandos que calculen simb\[OAcute]licamente integrales de l\
\[IAcute]nea de campos escalares de dos y tres variables. La sintaxis de \
estos comandos debe ser de la forma \"integlinea[f_,\[Gamma]_,a_,b_]\" donde \
debes suponer que \"f\" es el nombre de una funci\[OAcute]n conocida de dos o \
tres variables, \"\[Gamma]\" es el nombre de la funci\[OAcute]n que nos da el \
camino de integraci\[OAcute]n y que se integra en el intervalo [a,b].
Aqu\[IAcute] tienes un ejemplo de lo que debe ser capaz de hacer tu comando. \
\[DownExclamation]No eval\[UAcute]es la celda!\
\>", "ExerciseText"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(f[x_, y_, z_] = x + y + z; \  (*\ 
      el\ campo\ escalar\ *) \n\[Gamma][t_] = {t, t, t\^2};\  (*\ 
      el\ camino\ de\ integraci\[OAcute]n\ *) \), "\n", 
    \(integlinea[f, \[Gamma], 0, 2] (*\ 
      este\ es\ el\ comando\ que\ t\[UAcute]\ debes\ definir\ y\ tiene\ que\ \
calcular\ simb\[OAcute]licamente\ la\ integral\ de\ l\[IAcute]nea\ del\ campo\
\ escalar\ f\ a\ lo\ largo\ del\ camino\ \[Gamma]\ para\ 0 \[LessEqual] 
        t \[LessEqual] 2\ *) \)}], "Input"],

Cell[BoxData[
    \(1\/48\ \((722\ \@2 - 3\ ArcSinh[2\ \@2])\)\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "Sugerencia. En ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " es preferibe definir las funciones en la forma f[x,y,z] a definirlas como \
f[{x,y,z}]. El problema aparece cuando queremos evaluar una funci\[OAcute]n \
definida de la forma f[x,y,z] en un vector {x,y,z}. Para ello sirve el \
comando Apply[f,{x,y,z}] cuya salida ser\[AAcute] f[x,y,z]. El comando \
Apply[f,{x,y,z}] suele escribirse f@@{x,y,z}. Si tienes esto en cuenta, con \
definir s\[OAcute]lo un comando puedes calcular integrales de l\[IAcute]nea \
de campos escalares de dos o tres variables (por favor, no m\[AAcute]s de una \
l\[IAcute]nea de c\[OAcute]digo)."
}], "ExerciseText"],

Cell[TextData[{
  "2) Usando el comando definido en el apartado anterior, calcula las \
siguientes integrales de l\[IAcute]nea de los campos escalares ",
  StyleBox["f",
    FontSlant->"Italic"],
  " sobre la curva \[Gamma].\na)  ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y) = x\ y\)]],
  " , ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](t) = \((2  cos\ t, \ sen\ t)\)\)]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] t \[LessEqual] \[Pi]/2\)]],
  ".\nb)  ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y) = y/x\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](t) = \((\ t\^4, \ \ t\^3)\)\)]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] t \[LessEqual] 1\)]],
  ".\nc)  ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y, z) = y\ sen\ z\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](t) = \((cos\ t, \ sen\ t, t)\)\)]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] t \[LessEqual] 2  \[Pi]\)]],
  ".\nd)  ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y, z) = x\ z\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](t) = \((6\ t, \ \ 3 \(\@ 2\) t\^2, 
          2  t\^3)\)\)]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] t \[LessEqual] 1\)]],
  ".\ne) ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(f(x, y, z) = 
        x + y + z\)\(,\)\(\ \)\(\[Gamma](t) = \((t, t, 
          t\^2)\)\)\(,\)\(\ \)\)\)]],
  "donde ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \)\(0 \[LessEqual] t \[LessEqual] 2\)\)\)]],
  "."
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 2", "Exercise"],

Cell[TextData[{
  "Repite lo hecho en el ejercicio 1 para definir un comando \
\"integlineavector[f_,\[Gamma]_,a_,b_]\" que calcule simb\[OAcute]licamente \
integrales de l\[IAcute]nea de campos vectoriales de dos y tres variables. \
Sugerencia: P\[IAcute]dele a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " que simplifique la funci\[OAcute]n que tiene que integrar."
}], "ExerciseText"],

Cell[TextData[{
  "Calcula las siguientes integrales de l\[IAcute]nea de los campos \
vectoriales ",
  StyleBox["f",
    FontSlant->"Italic"],
  " sobre la curva \[Gamma].\na)  ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y, z) = \((x, y, z)\)\)]],
  " , ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](t) = \((cos\ t, \ sen\ t, t)\)\)]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] t \[LessEqual] 2  \[Pi]\)]],
  ".\nb)  ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y, z) = \((x, \(-y\), x\ y)\)\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma]\)]],
  " es el segmento de recta que une los puntos ",
  Cell[BoxData[
      \(TraditionalForm\`\((2, 1, 3)\)\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`\((\(-4\), 6, 8)\)\)]],
  ".\nc) ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(f(x, y, z)\), "=", 
          RowBox[{
            RowBox[{"y", " ", 
              StyleBox["i",
                FontWeight->"Bold"]}], "-", 
            RowBox[{"x", " ", 
              StyleBox["j",
                FontWeight->"Bold"]}], " ", "+", " ", 
            StyleBox["k",
              FontWeight->"Bold"]}]}], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](t) = \((cos\ t, \ sen\ t, t)\)\)]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] t \[LessEqual] 2  \[Pi]\)]],
  ".\nd)  ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(f(x, y, z)\), "=", 
          RowBox[{
            RowBox[{"4", " ", "x", " ", \(\[ExponentialE]\^z\), 
              StyleBox["i",
                FontWeight->"Bold"]}], "+", 
            RowBox[{"cos", " ", "y", " ", 
              StyleBox["j",
                FontWeight->"Bold"]}], "+", 
            RowBox[{"2", \(x\^2\), \(\[ExponentialE]\^z\), 
              StyleBox["k",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Gamma](t)\), "=", " ", 
          RowBox[{
            RowBox[{"t", " ", 
              StyleBox["i",
                FontWeight->"Bold"]}], "+", 
            RowBox[{\(t\^2\), 
              StyleBox["j",
                FontWeight->"Bold"]}], "+", 
            RowBox[{\(t\^4\), 
              StyleBox["k",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] t \[LessEqual] 1\)]],
  "."
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 3", "Exercise"],

Cell[TextData[{
  "a) Define un comando para aproximar la integral de l\[IAcute]nea ",
  Cell[BoxData[
      \(TraditionalForm\`\[Integral]\_\[Gamma]\( f(x, 
            y)\) \[DifferentialD]s\)]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " es un campo escalar de dos variables y ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma] : \([a, 
            b]\) \[Rule] \[DoubleStruckCapitalR]\^2\)]],
  " es una curva en el plano que debes suponer conocidos. El comando debe \
tener la sintaxis \"aproxinteglinea[f_,\[Gamma]_,a_,b_,n_]\" y debe realizar \
las siguientes acciones:\n1. Dividir el intervalo [a,b] en n partes iguales \
por puntos ",
  Cell[BoxData[
      \(TraditionalForm\`t\_k = a + \(k(b - a)\)/n\)]],
  ". \n2. Calcular la suma ",
  Cell[BoxData[
      \(TraditionalForm\`\[Sum]\+\(j = 1\)\%n f(\[Gamma](t\_j)) || \[Gamma](
            t\_\(j - 1\)) - \[Gamma](t\_j) || \)]],
  ".\nLos c\[AAcute]lculos deben realizarse num\[EAcute]ricamente. \nb) \
Calcula de forma exacta, usando el comando que has definido en el ejercicio \
1, el \[AAcute]rea de una cortina cuya base es la circunferencia",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \)\(\[Gamma](
          t) = \((1 + cos\ t, \ \ sen\ t)\)\)\)\)]],
  Cell[BoxData[
      \(TraditionalForm\`\(\(,\)\(\ \)\(0 \[LessEqual] t \[LessEqual] 
        2  \[Pi]\)\)\)]],
  " y cuya altura en cada punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, y)\)\)]],
  " de la circunferencia viene dada por ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y) = \(\(\@\(4 - x\^2 - y\^2\)\)\(.\)\)\)]],
  " Calcula, usando el comando que has definido en el apartado anterior, una \
aproximaci\[OAcute]n del valor obtenido con tres cifras decimales exactas. "
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 4", "Exercise"],

Cell[TextData[{
  "a) Define un comando que te diga si un campo vectorial de dos variables es \
o no localmente conservativo. La sintaxis de dicho comando debe ser de la \
forma \"conservativoQ[Func]\" donde se supone que \"Func\" es el campo \
vectorial y su salida debe ser \"El campo es localmente conservativo\" o \"El \
campo no es localmente conservativo\". \nb) Haz lo mismo que en el apartado \
a) para campos vectoriales de tres variables.\nSugerencia. Debes usar el \
comando If[ ]. Para comprobar que dos funciones g[x,y], h[x,y]  son iguales \
es eficaz usar el comando ",
  Cell[BoxData[
      \(TraditionalForm\`Simplify[g[x, y] - h[x, y] == 0] === True\)]],
  ". El comando \"",
  Cell[BoxData[
      \(TraditionalForm\`exp1 === exp2\)]],
  "\" comprueba si las dos expresiones son ",
  StyleBox["id\[EAcute]nticas",
    FontSlant->"Italic"],
  ". La raz\[OAcute]n de esto puedes entenderla con el siguiente ejemplo."
}], "ExerciseText"],

Cell[BoxData[{
    \(Simplify[x \((x + y)\) - x\^2 - x\ y == 0]\  (*\ 
      salida\ True\ *) \), "\n", 
    \(Simplify[
      x \((x + y)\) - x\^2 == 
        0] (*\ \(salida\ que\ no\ es\ True\ y ... \)\ \
\[DownExclamation]tampoco\ \(False!\)\ Por\ eso\ no\ debe\ usarse\  \[Equal] \
\ como\ operador\ boleano\ cuando\ trabajamos\ \(simb\[OAcute]licamente : \ 
            porque\ no\ estamos\ seguros\ de\ que\ siempre\ sea\ True\ o\ \
False\)\ *) \), "\n", 
    \(Simplify[
      x \((x + y)\) - x\^2 - x\ y === 
        0]\  (*\ \[DownExclamation]salida\ \(False!\)\ Por\ eso\ no\ podemos\ \
usar\  === \ como\ operador\ \(boleano : \ 
            porque\ puede\ evaluarse\ de\ forma\ no\ apropiada\)\ *) \
\[IndentingNewLine] (*\ 
      pero\ combinando\ los\ dos\ operadores\ se\ consigue\ algo\ que\ parece\
\ funcionar\ bien\ *) \), "\[IndentingNewLine]", 
    \(Simplify[x \((x + y)\) - x\^2 == 0] === True\  (*\ salida\ False, \ 
      como\ debe\ ser\ *) \), "\n", 
    \(\(\(Simplify[
        x \((x + y)\) - x\^2 - x\ y == 0]\)\(===\)\(True\)\(\ \)\( (*\ 
        salida\ True, \ como\ debe\ ser\ *) \)\)\)}], "Input"],

Cell[TextData[{
  "c) Usando los comando desfinidos en los apartados anteriores, estudia si \
los siguiente campos son localmente conservativos. \[DownQuestion]Son \
conservativos en todo su dominio de definici\[OAcute]n?\na) ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(f(x, y)\), "=", 
          RowBox[{\(Exp[x]\), 
            RowBox[{"(", 
              RowBox[{
                RowBox[{\(Cos[y]\), " ", 
                  StyleBox["i",
                    FontWeight->"Bold"]}], " ", "-", " ", 
                RowBox[{\(Sin[y]\), " ", 
                  StyleBox["j",
                    FontWeight->"Bold"]}]}], ")"}]}]}], TraditionalForm]]],
  ".\nb) ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(f(x, y)\), "=", 
          RowBox[{
            RowBox[{\(y\^2\), " ", \(Exp[x\ y]\), 
              StyleBox["i",
                FontWeight->"Bold"]}], "+", 
            RowBox[{\(x\^2\), \(Exp[x\ y]\), 
              StyleBox["j",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  ".\nc) ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(f(x, y)\), "=", 
          RowBox[{
            RowBox[{\((6  y + y\ Exp[x\ y] + 1)\), 
              StyleBox["i",
                FontWeight->"Bold"]}], "+", 
            RowBox[{\((6  x + x\ Exp[x\ y])\), 
              StyleBox["j",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  ".\nd) ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(f(x, y, z)\), "=", 
          RowBox[{
            RowBox[{\(y\^2\), \(z\^3\), 
              StyleBox["i",
                FontWeight->"Bold"]}], "+", 
            RowBox[{"2", " ", "x", " ", "y", " ", \(z\^3\), 
              StyleBox["j",
                FontWeight->"Bold"]}], "+", 
            RowBox[{"3", "x", " ", \(y\^2\), \(z\^2\), 
              StyleBox["k",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  ".\ne) ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(f(x, y, z)\), "=", 
          RowBox[{
            RowBox[{"(", 
              RowBox[{
                RowBox[{"x", " ", 
                  StyleBox["i",
                    FontWeight->"Bold"]}], " ", "+", " ", 
                RowBox[{"y", " ", 
                  StyleBox["j",
                    FontWeight->"Bold"]}], " ", "+", " ", 
                RowBox[{"z", " ", 
                  StyleBox["k",
                    FontWeight->"Bold"]}]}], ")"}], 
            "/", \(\@\(x\^2 + y\^2 + z\^2\)\)}]}], TraditionalForm]]],
  "."
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 5", "Exercise"],

Cell[TextData[{
  "a) Define un comando que calcule simb\[OAcute]licamente una \
funci\[OAcute]n potencial de un campo vectorial de dos variables. La sintaxis \
del comando debe ser de la forma \"potencial[F][x,y]\" donde \"F\" es el \
campo. \nSugerencia. Un comando If[ ] es suficiente. Debes volver a comprobar \
si el campo es conservativo y para eso no creo que puedas usar el comando \
anterior. La expresi\[OAcute]n que obtuvimos en clase para la funci\[OAcute]n \
potencial puede ser \[UAcute]til pero debes usar comandos Integrate[ ] para \
calcular primitivas, NO integrales definidas porque eso da muchos problemas. \
Es decir, mientras que Integrate[func[x,y],x] calcula (cuando puede) una \
primitiva de func[x,y] respecto a x sin dar problemas, \
Integrate[func[u,y],{u,a,x}] tambi\[EAcute]n calcula una primitiva respecto a \
x pero con frecuencia da problemas.\nb) Calcula con el comando que has \
definido los  potenciales que se anulan en (0,0) de los campos siguientes:\n\
b1)",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \)\(F(x, y) = \((y, x)\)\)\)\)]],
  "\nb2) ",
  Cell[BoxData[
      \(TraditionalForm\`F(x, y) = \((3 + 2  x\ y, x\^2 - 3  y\^2)\)\)]],
  "\nb3) ",
  Cell[BoxData[
      \(TraditionalForm\`F(x, 
          y) = \((2  x\ sen\ y, \(x\^2\) cos\ y - 3  y\^2)\)\)]],
  "\nb4) ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(F(x, y)\), "=", 
          RowBox[{
            RowBox[{\((2  y\^2 - 12 \( x\^3\) y\^3)\), 
              StyleBox["i",
                FontWeight->"Bold"]}], "+", 
            RowBox[{\((4  x\ y\  - \ 9 \( x\^4\) y\^2)\), 
              StyleBox["j",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  "\nb5) ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(F(x, y)\), "=", 
          RowBox[{
            RowBox[{\((\(y\^2\) cos\ x + 2  x\ \[ExponentialE]\^y)\), 
              StyleBox["i",
                FontWeight->"Bold"]}], "+", 
            RowBox[{\((2  y\ sen\ x\  + \ x\^2\ \[ExponentialE]\^y)\), 
              StyleBox["j",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  "\nc) Haz lo mismo que en el apartado a) para campos vectoriales de tres \
variables.\nd) Calcula con el comando que has definido potenciales que se \
anulan en (0,0) de los campos siguientes:\nd1)",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          RowBox[{
            
            FormBox[\(F(x, y, z) = \((y, \ x + z\ \(cos(y\ z)\), \ 
                  y\ \(cos(y\ z)\))\)\),
              "TraditionalForm"], " ", "."}]}], TraditionalForm]]],
  "\nd2) ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          
          FormBox[\(F(x, y, 
                z) = \((2\ x\ y\ z + sen\ x, \(x\^2\) z, \(x\^2\) y)\)\),
            "TraditionalForm"], 
          StyleBox[".",
            FontFamily->"CMR10",
            FontSize->10]}], TraditionalForm]]]
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 6", "Exercise"],

Cell[TextData[{
  "Usa ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " para calcular,  haciendo uso del teorema de Green, las integrales de l\
\[IAcute]nea de los campos vecoriales ",
  Cell[BoxData[
      \(TraditionalForm\`F\)]],
  " en los caminos \[Gamma] indicados.\na) ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(F(x, y)\), "=", 
          RowBox[{
            RowBox[{\((x\^2 - y\^2)\), 
              StyleBox["i",
                FontWeight->"Bold"]}], "+", 
            RowBox[{"2", " ", "x", " ", "y", " ", 
              StyleBox["j",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma] = \([\((0, 0)\), \((0, 2)\), \((2, 
            2)\), \((0, 2)\), \((0, 0)\)]\)\)]],
  ".\nb) ",
  Cell[BoxData[
      \(TraditionalForm\`F(x, y) = \((2  x\ y\^2, \ \(x\^2\) y)\)\)]],
  ", \[Gamma] es la elipse ",
  Cell[BoxData[
      \(TraditionalForm\`4  x\^2 + y\^2 = 4\)]],
  ".\nc) ",
  Cell[BoxData[
      \(TraditionalForm\`F(x, y) = \((\(-x\^2\) y, \ x\ y\^2)\)\)]],
  ", \[Gamma] es la mitad superior de la circunferencia ",
  Cell[BoxData[
      \(TraditionalForm\`x\^2 + y\^2 = r\^2\)]],
  " y el segmento ",
  Cell[BoxData[
      \(TraditionalForm\`\([\((\(-r\), 0)\), \((r, 0)\)]\)\)]],
  ".\nd) ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(F(x, y)\), "=", 
          RowBox[{
            RowBox[{\((cos\ x - 3  y)\), 
              StyleBox["i",
                FontWeight->"Bold"]}], "+", 
            RowBox[{\((x\^2 + 2  \[ExponentialE]\^y)\), 
              StyleBox["j",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  ", \[Gamma] es la circunferencia de centro (1,2) y radio 2.\ne)",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[
            RowBox[{"  ", 
              RowBox[{\(F\ \((x, y)\)\), "=", 
                RowBox[{
                  
                  RowBox[{\((3\ y\  - \[ExponentialE]\^\(sen\ x\))\), Cell[
                    TextData[StyleBox["i",
                      FontWeight->"Bold",
                      FontSlant->"Italic"]]]}], "+"}]}]}],
            "TraditionalForm"], \((7  x + \@\(y\^4 + 1\))\), 
          StyleBox["j",
            FontWeight->"Bold"], Cell[TextData[StyleBox["",
            FontWeight->"Bold"]]]}], TraditionalForm]], "Text",
    TextAlignment->Center],
  "donde ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](t) = \((3\ cos\ t, \ 3\ sen\ t)\), \ 
      0 \[LessEqual] t \[LessEqual] 2  \[Pi]\)]],
  "."
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 7", "Exercise"],

Cell["\<\
En este ejercicio te propongo que uses el teorema de Green para calcular el \
\[AAcute]rea de un lago que t\[UAcute] mismo vas a dibujar.
a) El lago est\[AAcute] protegido por un seto que puedes ver ejecutando la \
celda siguiente. \
\>", "ExerciseText"],

Cell[BoxData[{
    \(\(seto = 
        Graphics[{Hue[ .45], Thickness[ .007], 
            Line[{{0, 0}, {2, 0}, {2, 2}, {0, 2}, {0, 
                  0}}]}];\)\), "\[IndentingNewLine]", 
    \(\(Show[seto, AspectRatio \[Rule] 1];\)\)}], "Input"],

Cell[TextData[{
  "b) Ahora debes dibujar el lago. Para ello sit\[UAcute]a el cursor del rat\
\[OAcute]n cerca de uno de los bordes del seto y haz click. Pulsa  la tecla \
\"Control\" y mantenla apretada. Ver\[AAcute]s que el cursos del \
rat\[OAcute]n ha cambiado y ahora es una cruz (quiz\[AAcute]s tengas que \
mover un poquit\[IAcute]n el rat\[OAcute]n). Manteniendo apretada \"Control\" \
y apretando el bot\[OAcute]n izquierdo del rat\[OAcute]n a la vez, desliza \
suavemente el rat\[OAcute]n en sentido antihorario alrededor del marco \
recorriendo un camino que puede ser todo lo irregular que t\[UAcute] quieras \
pero que no debe tener autointersecciones hasta llegar al punto de partida. \
En este momento sueltas \"Control\" y el bot\[OAcute]n izquierdo del rat\
\[OAcute]n. Dentro del marco habr\[AAcute]n aparecido unos puntos. En el men\
\[UAcute] \"Edit\" seleccionas \"Copy\" creas una nueva celda y usando \
\"Paste\" obtendr\[AAcute]s una lista con los puntos que ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ha creado a lo largo de tu camino. Ll\[AAcute]male a la lista \
\"vertices\" y pon al final de ella un ; para que ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " no vuelva a escribirla. \nVamos a usar los puntos de esa lista como v\
\[EAcute]rtices de un pol\[IAcute]gono que va ser nuestro lago y le vamos a \
dar un bonito color azul. Para eso hay que a\[NTilde]adir al final de la \
lista \"vertices\" el primer punto de dicha lista. A la nueva lista le damos \
el mismo nombre. Para que quede m\[AAcute]s bonito podemos dibujar las \
orillas del lago usando la primitiva gr\[AAcute]fica Line[ ]. "
}], "ExerciseText"],

Cell[BoxData[
    \(\(\( (*\ 
      antes\ de\ ejecutar\ esta\ celda\ debes\ pegar\ los\ puntos\ que\ has\ \
copiado\ *) \)\(\[IndentingNewLine]\)\(\(\(\(vertices\)\(=\)\) (*\ 
        aqu\[IAcute]\ debes\ pegar\ los\ puntos\ que\ has\ copiado\ *) ;\)\
\[IndentingNewLine]
    \(vertices = Append[vertices, vertices[\([1]\)]];\)\[IndentingNewLine]
    \(lago = Graphics[{Hue[ .65], Polygon[vertices]}];\)\[IndentingNewLine]
    \(orillas = 
        Graphics[{Thickness[0.01], Hue[ .16], 
            Line[vertices]}];\)\[IndentingNewLine]
    \(Show[{lago, orillas, \ seto}, AspectRatio \[Rule] 1];\)\)\)\)], "Input"],

Cell["Debe queda algo parecido a esto.", "ExerciseText"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.0238095 0.952381 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 .1 1 r
.86529 .48485 m
.86072 .49877 L
.85376 .5103 L
.84919 .51965 L
.8468 .529 L
.84441 .54053 L
.84441 .55206 L
.84441 .56141 L
.84441 .57294 L
.84441 .58686 L
.84441 .59861 L
.8468 .60774 L
.84919 .6171 L
.85376 .62645 L
.85833 .64037 L
.86529 .65429 L
.87464 .66343 L
.8816 .67278 L
.89096 .68214 L
.90248 .69127 L
.91401 .70302 L
.92337 .71215 L
.93033 .72151 L
.93489 .73086 L
.93968 .74 L
.94185 .74935 L
.94425 .76088 L
.94425 .77023 L
.94425 .78415 L
.94425 .79568 L
.93968 .80504 L
.93033 .81439 L
.92097 .81896 L
.91184 .82135 L
.90248 .82135 L
.89313 .82135 L
.87921 .81656 L
.86529 .812 L
.85615 .80264 L
.8468 .79568 L
.83288 .78655 L
.82352 .77719 L
.81656 .76566 L
.80743 .76088 L
.79568 .75174 L
.78655 .74478 L
.7748 .73543 L
.76327 .72608 L
.75174 .71911 L
.74 .71215 L
.73086 .70998 L
.72151 .70759 L
.71215 .70519 L
.70302 .70519 L
.69366 .70759 L
.68214 .71911 L
.67278 .73086 L
.66343 .74239 L
.65886 .75631 L
.65647 .77023 L
.65429 .78415 L
.65429 .79351 L
.65429 .80264 L
.65886 .812 L
.66125 .82135 L
.66582 .83048 L
.67039 .83984 L
.67278 .85137 L
.67278 .86311 L
.67278 .87225 L
.67039 .8816 L
.66125 .89096 L
.6519 .89552 L
.64037 .89792 L
.63102 .90009 L
.61949 .90248 L
.60774 .90488 L
.59622 .90488 L
.58469 .90488 L
.57077 .90488 L
.56141 .90488 L
.5451 .90009 L
.53357 .89552 L
.52204 .89096 L
.5103 .88617 L
.49877 .87225 L
.48941 .86072 L
.48485 .85137 L
.48245 .84223 L
.47789 .82592 L
.47789 .81656 L
.47549 .80047 L
.47549 .78872 L
.47549 .77719 L
.47549 .76327 L
.47549 .75392 L
.47549 .74478 L
.48028 .73304 L
.48485 .7239 L
.49181 .71455 L
.49877 .70302 L
.50812 .69606 L
.52204 .68431 L
.53814 .67518 L
.54749 .66822 L
.55902 .65886 L
.56598 .64733 L
.57294 .63798 L
.5823 .62167 L
.58469 .61253 L
.58926 .59861 L
.58926 .58686 L
.58926 .57533 L
.58926 .56598 L
.58686 .54988 L
.5823 .54053 L
.57533 .53118 L
.55902 .51965 L
.5451 .51269 L
.53596 .5103 L
.52204 .50573 L
.50573 .50334 L
.48485 .50334 L
.47092 .50334 L
.457 .50334 L
.44308 .50334 L
.43155 .50573 L
.41981 .51269 L
.40828 .529 L
.39893 .54053 L
.39197 .55684 L
.3874 .57294 L
.38044 .58686 L
.37348 .60078 L
.37108 .61253 L
.37108 .62406 L
.36891 .64037 L
.36412 .65647 L
.36195 .66822 L
.36195 .67974 L
.36195 .69606 L
.36195 .70519 L
.36195 .72151 L
.36195 .73782 L
.36195 .75392 L
.36195 .76327 L
.36195 .77262 L
.35956 .78176 L
.35956 .79111 L
.35499 .80743 L
.35499 .81656 L
.3502 .82831 L
.34324 .83745 L
.3341 .84441 L
.31779 .8468 L
.30626 .84919 L
.29452 .84919 L
.2806 .85137 L
.26211 .85137 L
.25058 .84919 L
.23426 .84919 L
.22034 .84441 L
.21099 .83984 L
.20185 .83288 L
.19011 .82592 L
.17858 .81439 L
.16705 .80743 L
.1553 .79111 L
.14617 .78655 L
.13921 .7748 L
.13225 .76327 L
.12529 .74696 L
.12289 .73304 L
.1205 .72151 L
.11593 .71215 L
.11593 .70302 L
.11354 .69366 L
.11137 .68431 L
.11137 .67278 L
.11137 .66343 L
.11137 .65429 L
.11137 .64037 L
.11137 .63102 L
.11833 .6171 L
.1205 .60774 L
.12985 .59622 L
.13921 .58686 L
.14617 .57533 L
.1553 .56141 L
.16923 .54988 L
.18554 .53596 L
.20881 .52661 L
.22491 .51726 L
.23666 .50812 L
.24579 .50116 L
.25754 .48941 L
.27363 .47789 L
.28299 .46853 L
.29691 .45461 L
.30626 .44069 L
.31322 .43155 L
.31779 .41981 L
.32475 .41067 L
.32714 .39675 L
.32932 .385 L
.3341 .37348 L
.3341 .36412 L
.3341 .35259 L
.3341 .33867 L
.33171 .32932 L
.33171 .32018 L
.32714 .30844 L
.31779 .29691 L
.30387 .28538 L
.29452 .27842 L
.2806 .26667 L
.27146 .26211 L
.26211 .25515 L
.25275 .25058 L
.23883 .24362 L
.2297 .23666 L
.21795 .23187 L
.20881 .22274 L
.19707 .21338 L
.18793 .20403 L
.17858 .19011 L
.17401 .17619 L
.17162 .16466 L
.17162 .1553 L
.17162 .14617 L
.17162 .13682 L
.17619 .12746 L
.18793 .11354 L
.19946 .1044 L
.20881 .10201 L
.22491 .09744 L
.23666 .09744 L
.24818 .09266 L
.25971 .09266 L
.27363 .09266 L
.28756 .09266 L
.30626 .09266 L
.31779 .09266 L
.32714 .09505 L
.34107 .10201 L
.34803 .11137 L
.35956 .12289 L
.36652 .13442 L
.37587 .15074 L
.39197 .16705 L
.39675 .18097 L
.40371 .1925 L
.40828 .20185 L
.41285 .21338 L
.41763 .22274 L
.4222 .23426 L
.42677 .24579 L
.42916 .25971 L
.43373 .27146 L
.43851 .28299 L
.44308 .2993 L
.44548 .31083 L
.44765 .32018 L
.45244 .33171 L
.457 .34107 L
.46396 .35499 L
.46853 .36412 L
.47789 .36891 L
.48941 .36891 L
.50573 .35956 L
.52204 .35499 L
.53596 .3502 L
.5451 .34107 L
.55445 .32714 L
.56381 .31083 L
.57533 .29691 L
.5823 .2806 L
.58926 .27146 L
.60078 .25515 L
.60557 .24362 L
.61471 .23426 L
.62406 .22274 L
.62863 .21338 L
.63798 .20403 L
.64951 .19011 L
.66582 .17619 L
.68214 .16466 L
.69606 .15313 L
.70998 .14617 L
.72151 .14138 L
.73543 .14138 L
.74696 .14138 L
.75631 .14138 L
.77262 .14138 L
.78176 .14378 L
.79351 .14617 L
.80264 .14834 L
.812 .15074 L
.82135 .1553 L
.83048 .1577 L
.84223 .16466 L
.85376 .16923 L
.86529 .18097 L
.87464 .18793 L
.88856 .20403 L
.89552 .21338 L
.90009 .22274 L
.90705 .23187 L
.91401 .24579 L
.9188 .25515 L
.92097 .2645 L
.92337 .27363 L
.93033 .28995 L
.93033 .30387 L
.93033 .32018 L
.93033 .33171 L
.93033 .34107 L
.93033 .3502 L
.93033 .35956 L
.93033 .37348 L
.93033 .38283 L
.92576 .39675 L
.92337 .40828 L
.9188 .41981 L
.91401 .42916 L
.90944 .44069 L
.90009 .45244 L
.89096 .46157 L
.88399 .47092 L
.87703 .48028 L
.87007 .48941 L
.86529 .48485 L
F
1 .96 0 r
.01 w
[ ] 0 setdash
.86529 .48485 m
.86072 .49877 L
.85376 .5103 L
.84919 .51965 L
.8468 .529 L
.84441 .54053 L
.84441 .55206 L
.84441 .56141 L
.84441 .57294 L
.84441 .58686 L
.84441 .59861 L
.8468 .60774 L
.84919 .6171 L
.85376 .62645 L
.85833 .64037 L
.86529 .65429 L
.87464 .66343 L
.8816 .67278 L
.89096 .68214 L
.90248 .69127 L
.91401 .70302 L
.92337 .71215 L
.93033 .72151 L
.93489 .73086 L
.93968 .74 L
.94185 .74935 L
.94425 .76088 L
.94425 .77023 L
.94425 .78415 L
.94425 .79568 L
.93968 .80504 L
.93033 .81439 L
.92097 .81896 L
.91184 .82135 L
.90248 .82135 L
.89313 .82135 L
.87921 .81656 L
.86529 .812 L
.85615 .80264 L
.8468 .79568 L
.83288 .78655 L
.82352 .77719 L
.81656 .76566 L
.80743 .76088 L
.79568 .75174 L
.78655 .74478 L
.7748 .73543 L
.76327 .72608 L
.75174 .71911 L
.74 .71215 L
Mistroke
.73086 .70998 L
.72151 .70759 L
.71215 .70519 L
.70302 .70519 L
.69366 .70759 L
.68214 .71911 L
.67278 .73086 L
.66343 .74239 L
.65886 .75631 L
.65647 .77023 L
.65429 .78415 L
.65429 .79351 L
.65429 .80264 L
.65886 .812 L
.66125 .82135 L
.66582 .83048 L
.67039 .83984 L
.67278 .85137 L
.67278 .86311 L
.67278 .87225 L
.67039 .8816 L
.66125 .89096 L
.6519 .89552 L
.64037 .89792 L
.63102 .90009 L
.61949 .90248 L
.60774 .90488 L
.59622 .90488 L
.58469 .90488 L
.57077 .90488 L
.56141 .90488 L
.5451 .90009 L
.53357 .89552 L
.52204 .89096 L
.5103 .88617 L
.49877 .87225 L
.48941 .86072 L
.48485 .85137 L
.48245 .84223 L
.47789 .82592 L
.47789 .81656 L
.47549 .80047 L
.47549 .78872 L
.47549 .77719 L
.47549 .76327 L
.47549 .75392 L
.47549 .74478 L
.48028 .73304 L
.48485 .7239 L
.49181 .71455 L
Mistroke
.49877 .70302 L
.50812 .69606 L
.52204 .68431 L
.53814 .67518 L
.54749 .66822 L
.55902 .65886 L
.56598 .64733 L
.57294 .63798 L
.5823 .62167 L
.58469 .61253 L
.58926 .59861 L
.58926 .58686 L
.58926 .57533 L
.58926 .56598 L
.58686 .54988 L
.5823 .54053 L
.57533 .53118 L
.55902 .51965 L
.5451 .51269 L
.53596 .5103 L
.52204 .50573 L
.50573 .50334 L
.48485 .50334 L
.47092 .50334 L
.457 .50334 L
.44308 .50334 L
.43155 .50573 L
.41981 .51269 L
.40828 .529 L
.39893 .54053 L
.39197 .55684 L
.3874 .57294 L
.38044 .58686 L
.37348 .60078 L
.37108 .61253 L
.37108 .62406 L
.36891 .64037 L
.36412 .65647 L
.36195 .66822 L
.36195 .67974 L
.36195 .69606 L
.36195 .70519 L
.36195 .72151 L
.36195 .73782 L
.36195 .75392 L
.36195 .76327 L
.36195 .77262 L
.35956 .78176 L
.35956 .79111 L
.35499 .80743 L
Mistroke
.35499 .81656 L
.3502 .82831 L
.34324 .83745 L
.3341 .84441 L
.31779 .8468 L
.30626 .84919 L
.29452 .84919 L
.2806 .85137 L
.26211 .85137 L
.25058 .84919 L
.23426 .84919 L
.22034 .84441 L
.21099 .83984 L
.20185 .83288 L
.19011 .82592 L
.17858 .81439 L
.16705 .80743 L
.1553 .79111 L
.14617 .78655 L
.13921 .7748 L
.13225 .76327 L
.12529 .74696 L
.12289 .73304 L
.1205 .72151 L
.11593 .71215 L
.11593 .70302 L
.11354 .69366 L
.11137 .68431 L
.11137 .67278 L
.11137 .66343 L
.11137 .65429 L
.11137 .64037 L
.11137 .63102 L
.11833 .6171 L
.1205 .60774 L
.12985 .59622 L
.13921 .58686 L
.14617 .57533 L
.1553 .56141 L
.16923 .54988 L
.18554 .53596 L
.20881 .52661 L
.22491 .51726 L
.23666 .50812 L
.24579 .50116 L
.25754 .48941 L
.27363 .47789 L
.28299 .46853 L
.29691 .45461 L
.30626 .44069 L
Mistroke
.31322 .43155 L
.31779 .41981 L
.32475 .41067 L
.32714 .39675 L
.32932 .385 L
.3341 .37348 L
.3341 .36412 L
.3341 .35259 L
.3341 .33867 L
.33171 .32932 L
.33171 .32018 L
.32714 .30844 L
.31779 .29691 L
.30387 .28538 L
.29452 .27842 L
.2806 .26667 L
.27146 .26211 L
.26211 .25515 L
.25275 .25058 L
.23883 .24362 L
.2297 .23666 L
.21795 .23187 L
.20881 .22274 L
.19707 .21338 L
.18793 .20403 L
.17858 .19011 L
.17401 .17619 L
.17162 .16466 L
.17162 .1553 L
.17162 .14617 L
.17162 .13682 L
.17619 .12746 L
.18793 .11354 L
.19946 .1044 L
.20881 .10201 L
.22491 .09744 L
.23666 .09744 L
.24818 .09266 L
.25971 .09266 L
.27363 .09266 L
.28756 .09266 L
.30626 .09266 L
.31779 .09266 L
.32714 .09505 L
.34107 .10201 L
.34803 .11137 L
.35956 .12289 L
.36652 .13442 L
.37587 .15074 L
.39197 .16705 L
Mistroke
.39675 .18097 L
.40371 .1925 L
.40828 .20185 L
.41285 .21338 L
.41763 .22274 L
.4222 .23426 L
.42677 .24579 L
.42916 .25971 L
.43373 .27146 L
.43851 .28299 L
.44308 .2993 L
.44548 .31083 L
.44765 .32018 L
.45244 .33171 L
.457 .34107 L
.46396 .35499 L
.46853 .36412 L
.47789 .36891 L
.48941 .36891 L
.50573 .35956 L
.52204 .35499 L
.53596 .3502 L
.5451 .34107 L
.55445 .32714 L
.56381 .31083 L
.57533 .29691 L
.5823 .2806 L
.58926 .27146 L
.60078 .25515 L
.60557 .24362 L
.61471 .23426 L
.62406 .22274 L
.62863 .21338 L
.63798 .20403 L
.64951 .19011 L
.66582 .17619 L
.68214 .16466 L
.69606 .15313 L
.70998 .14617 L
.72151 .14138 L
.73543 .14138 L
.74696 .14138 L
.75631 .14138 L
.77262 .14138 L
.78176 .14378 L
.79351 .14617 L
.80264 .14834 L
.812 .15074 L
.82135 .1553 L
.83048 .1577 L
Mistroke
.84223 .16466 L
.85376 .16923 L
.86529 .18097 L
.87464 .18793 L
.88856 .20403 L
.89552 .21338 L
.90009 .22274 L
.90705 .23187 L
.91401 .24579 L
.9188 .25515 L
.92097 .2645 L
.92337 .27363 L
.93033 .28995 L
.93033 .30387 L
.93033 .32018 L
.93033 .33171 L
.93033 .34107 L
.93033 .3502 L
.93033 .35956 L
.93033 .37348 L
.93033 .38283 L
.92576 .39675 L
.92337 .40828 L
.9188 .41981 L
.91401 .42916 L
.90944 .44069 L
.90009 .45244 L
.89096 .46157 L
.88399 .47092 L
.87703 .48028 L
.87007 .48941 L
.86529 .48485 L
Mfstroke
0 1 .7 r
.007 w
.02381 .02381 m
.97619 .02381 L
.97619 .97619 L
.02381 .97619 L
.02381 .02381 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006`0001/2000`400?l00000o`00003oo`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`002@3ooooo
003o/ih00?nc2P3oool000T0ooooo`00ok>N003o/`X0oooo00090?ooool00?ncWP00ok<:0?ooo`00
2@3oool3003o/ol0ooooV03oool3003o/`X0oooo00090?ooo`<00?nco`3ooonH0?ooo`<00?nc2P3o
ool000T0oooo0`00ok?o0?oooiP0oooo0`00ok<:0?ooo`002@3oool3003o/ol0ooooV03oool3003o
/`X0oooo00090?ooo`<00?nco`3ooonH0?ooo`<00?nc2P3oool000T0oooo0`00ok?o0?oooiP0oooo
0`00ok<:0?ooo`002@3oool3003o/ol0ooooV03oool3003o/`X0oooo00090?ooo`<00?nco`3ooonH
0?ooo`<00?nc2P3oool000T0oooo0`00ok?o0?oooiP0oooo0`00ok<:0?ooo`002@3oool3003o/ol0
ooooV03oool3003o/`X0oooo00090?ooo`<00?nco`3ooonH0?ooo`<00?nc2P3oool000T0oooo0`00
ok?o0?oooiP0oooo0`00ok<:0?ooo`002@3oool3003o/ol0ooooV03oool3003o/`X0oooo00090?oo
o`<00?nco`3ooonH0?ooo`<00?nc2P3oool000T0oooo0`00ok?o0?oooiP0oooo0`00ok<:0?ooo`00
2@3oool3003o/ol0ooooV03oool3003o/`X0oooo00090?ooo`<00?nco`3ooonH0?ooo`<00?nc2P3o
ool000T0oooo0`00ok?o0?oooiP0oooo0`00ok<:0?ooo`002@3oool3003o/ol0ooooV03oool3003o
/`X0oooo00090?ooo`<00?nco`3ooonH0?ooo`<00?nc2P3oool000T0oooo0`00ok?o0?oooiP0oooo
0`00ok<:0?ooo`002@3oool3003o/ol0ooooV03oool3003o/`X0oooo00090?ooo`<00?nco`3ooonH
0?ooo`<00?nc2P3oool000T0oooo0`00ok?o0?oooiP0oooo0`00ok<:0?ooo`002@3oool3003o/ol0
ooooV03oool3003o/`X0oooo00090?ooo`<00?nco`3ooonH0?ooo`<00?nc2P3oool000T0oooo0`00
ok=K0?ooobL0ooD0o`3ooolF0?ooo`<00?nc2P3oool000T0oooo0`00ok=I0?ooob/0ooD0o`3ooolD
0?ooo`<00?nc2P3oool000T0oooo0`00ok=A0?ooocD0ooD0o`3ooolB0?ooo`<00?nc2P3oool000T0
oooo0`00ok=>0?ooocX0ooD0o`3oool@0?ooo`<00?nc2P3oool000T0oooo0`00ok=90?oooa@0ooD0
8`006Ol90?oe0?l0oooo3`3oool3003o/`X0oooo00090?ooo`<00?ncA`3ooolD0?oe02L001Wo203o
m@3o0?ooo`h0oooo0`00ok<:0?ooo`002@3oool3003o/dH0oooo303om@0b000Io`H0ooD0o`3oool>
0?ooo`<00?nc2P3oool000T0oooo0`00ok=50?ooo`X0ooD0>0006Ol40?oe0?l0oooo3@3oool3003o
/`X0oooo00090?ooo`<00?ncA03oool60?oe03d001Wo103om@3o0?ooo`d0oooo0`00ok<:0?ooo`00
2@3oool3003o/d<0oooo1P3om@0o000Io`@0ooD0o`3oool<0?ooo`<00?nc2P3oool000T0oooo0`00
ok=20?ooo`H0ooD0@0006Ol50?oe0?l0oooo2`3oool3003o/`X0oooo00090?ooo`<00?nc@@3oool6
0?oe048001Wo1@3om@3o0?ooo`X0oooo0`00ok<:0?ooo`002@3oool3003o/d00oooo1P3om@14000I
o`D0ooD0o`3oool90?ooo`<00?nc2P3oool000T0oooo0`00ok<o0?ooo`H0ooD0A@006Ol60?oe0?l0
oooo203oool3003o/`X0oooo00090?ooo`<00?nc?P3oool60?oe04L001Wo1P3om@3o0?ooo`L0oooo
0`00ok<:0?ooo`002@3oool3003o/ch0oooo1@3om@19000Io`D0ooD0o`3oool70?ooo`<00?nc2P3o
ool000T0oooo0`00ok<m0?ooo`D0ooD0C0006Ol40?oe0?l0oooo1P3oool3003o/`X0oooo00090?oo
o`<00?nc?@3oool40?oe04d001Wo103om@3o0?ooo`H0oooo0`00ok<:0?ooo`002@3oool3003o/c`0
oooo103om@1?000Io`@0ooD0o`3oool50?ooo`<00?nc2P3oool000T0oooo0`00ok<l0?ooo`@0ooD0
C`006Ol50?oe0?l0oooo103oool3003o/`X0oooo00090?ooo`<00?nc>`3oool40?oe054001Wo1@3o
m@3o0?ooo`<0oooo0`00ok<:0?ooo`002@3oool3003o/c/0oooo103om@1B000Io`@0ooD0TP3ooolN
0?oe0580oooo0`00ok<:0?ooo`002@3oool3003o/c/0oooo103om@1B000Io`D0ooD0S`3ooolV0?oe
04`0oooo0`00ok<:0?ooo`002@3oool3003o/c/0oooo103om@1C000Io`D0ooD0S03oool[0?oe04T0
oooo0`00ok<:0?ooo`002@3oool3003o/c/0oooo103om@1C000Io`H0ooD0R@3ooola0?oe04D0oooo
0`00ok<:0?ooo`002@3oool3003o/c/0oooo103om@1D000Io`D0ooD0R03oool90?oe01/001Wo4@3o
m@120?ooo`<00?nc2P3oool000T0oooo0`00ok<k0?ooo`@0ooD0E@006Ol50?oe08D0oooo2@3om@0S
000Io`d0ooD0@03oool3003o/`X0oooo00090?ooo`<00?nc>`3oool40?oe05H001Wo1@3om@230?oo
o`P0ooD0:0006Ol=0?oe03d0oooo0`00ok<:0?ooo`002@3oool3003o/c/0oooo103om@1F000Io`H0
ooD0P@3oool70?oe02d001Wo303om@0k0?ooo`<00?nc2P3oool000T0oooo0`00ok<k0?ooo`@0ooD0
E`006Ol60?oe07l0oooo1P3om@0b000Io`/0ooD0>@3oool3003o/`X0oooo00090?ooo`<00?nc>`3o
ool40?oe05P001Wo1P3om@1m0?ooo`H0ooD0=P006Ol:0?oe03L0oooo0`00ok<:0?ooo`002@3oool3
003o/c/0oooo103om@1I000Io`H0ooD0N`3oool60?oe03T001Wo2P3om@0e0?ooo`<00?nc2P3oool0
00T0oooo0`00ok<k0?ooo`D0ooD0F@006Ol50?oe07T0oooo1`3om@0l000Io`X0ooD0<`3oool3003o
/`X0oooo00090?ooo`<00?nc>`3oool50?oe05X001Wo1@3om@1f0?ooo`L0ooD0@0006Ol90?oe0380
oooo0`00ok<:0?ooo`002@3oool3003o/c`0oooo1@3om@1J000Io`@0ooD0M@3oool70?oe04<001Wo
203om@0a0?ooo`<00?nc2P3oool000T0oooo0`00ok<l0?ooo`D0ooD0FP006Ol50?oe0780oooo1`3o
m@17000Io`L0ooD0<03oool3003o/`X0oooo00090?ooo`<00?nc?@3oool40?oe05/001Wo103om@1a
0?ooo`H0ooD0B`006Ol60?oe02l0oooo0`00ok<:0?ooo`002@3oool3003o/cd0oooo1@3om@1K000I
o`@0ooD0KP3oool70?oe04d001Wo1P3om@0^0?ooo`<00?nc2P3oool000T0oooo0`00ok<n0?ooo`@0
ooD0F`006Ol40?oe06d0oooo1P3om@1@000Io`L0ooD0;03oool3003o/`X0oooo00090?ooo`<00?nc
?P3oool40?oe05`001Wo103om@1[0?ooo`H0ooD0DP006Ol70?oe02/0oooo0`00ok<:0?ooo`002@3o
ool3003o/ch0oooo103om@1L000Io`@0ooD0JP3oool60?oe05@001Wo1`3om@0Z0?ooo`<00?nc2P3o
ool000T0oooo0`00ok<n0?ooo`@0ooD0G@006Ol40?oe06P0oooo1P3om@1G000Io`H0ooD0:@3oool3
003o/`X0oooo00090?ooo`<00?nc?P3oool40?oe05d001Wo103om@1W0?ooo`H0ooD0F@006Ol60?oe
02P0oooo0`00ok<:0?ooo`002@3oool3003o/ch0oooo1@3om@1M000Io`@0ooD0I@3oool60?oe05/0
01Wo1P3om@0W0?ooo`<00?nc2P3oool000T0oooo0`00ok<o0?ooo`D0ooD0G0006Ol50?oe06<0oooo
1P3om@1M000Io`H0ooD09P3oool3003o/`X0oooo00090?ooo`<00?nc?`3oool60?oe05`001Wo103o
m@1R0?ooo`H0ooD0G`006Ol60?oe02D0oooo0`00ok<:0?ooo`002@3oool3003o/d00oooo1P3om@1K
000Io`@0ooD0H@3oool60?oe064001Wo1P3om@0T0?ooo`<00?nc2P3oool000T0oooo0`00ok=10?oo
o`H0ooD0FP006Ol40?oe0600oooo1P3om@1S000Io`H0ooD08`3oool3003o/`X0oooo00090?ooo`<0
0?nc@P3oool50?oe05X001Wo1@3om@1N0?ooo`H0ooD0I@006Ol50?oe02<0oooo0`00ok<:0?ooo`00
2@3oool3003o/d<0oooo1@3om@1J000Io`@0ooD0G@3oool60?oe06L001Wo1@3om@0R0?ooo`<00?nc
2P3oool000T0oooo0`00ok=40?ooo`D0ooD0F@006Ol50?oe05/0oooo1P3om@1Y000Io`D0ooD08@3o
ool3003o/`X0oooo00090?ooo`<00?ncA03oool60?oe05P001Wo1@3om@1J0?ooo`H0ooD0JP006Ol6
0?oe0200oooo0`00ok<:0?ooo`002@3oool3003o/dD0oooo1P3om@1H000Io`@0ooD0F@3oool60?oe
06`001Wo1@3om@0P0?ooo`<00?nc2P3oool000T0oooo0`00ok=60?ooo`H0ooD0E`006Ol50?oe05P0
oooo1@3om@1^000Io`D0ooD07`3oool3003o/`X0oooo00090?ooo`<00?ncA`3oool60?oe05L001Wo
103om@1H0?ooo`@0ooD0K`006Ol50?oe01l0oooo0`00ok<:0?ooo`002@3oool3003o/dP0oooo1P3o
m@1G000Io`@0ooD0EP3oool50?oe070001Wo1@3om@0N0?ooo`<00?nc2P3oool000T0oooo0`00ok=9
0?ooo`H0ooD0EP006Ol40?oe05H0oooo1@3om@1`000Io`D0ooD07P3oool3003o/`X0oooo00090?oo
o`<00?ncBP3oool60?oe05H001Wo103om@1D0?ooo`D0ooD0LP006Ol40?oe01h0oooo0`00ok<:0?oo
o`002@3oool3003o/d/0oooo1P3om@1E000Io`D0ooD0DP3oool60?oe078001Wo1@3om@0M0?ooo`<0
0?nc2P3oool000T0oooo0`00ok=<0?ooo`H0ooD0E@006Ol40?oe0540oooo1P3om@1c000Io`H0ooD0
703oool3003o/`X0oooo00090?ooo`<00?ncC@3oool80?oe058001Wo103om@1@0?ooo`H0ooD0M@00
6Ol60?oe01/0oooo0`00ok<:0?ooo`002@3oool3003o/dh0oooo2P3om@1?000Io`@0ooD0D03oool5
0?oe07L001Wo1@3om@0K0?ooo`<00?nc2P3oool000T0oooo0`00ok=?0?ooo`X0ooD0CP006Ol50?oe
04h0oooo1@3om@1i000Io`D0ooD06P3oool3003o/`X0oooo00090?ooo`<00?ncD@3oool90?oe04h0
01Wo103om@1=0?ooo`D0ooD0N`006Ol40?oe01X0oooo0`00ok<:0?ooo`002@3oool3003o/e@0oooo
1`3om@1=000Io`D0ooD0C03oool50?oe07`001Wo103om@0I0?ooo`<00?nc2P3oool000T0oooo0`00
ok=F0?ooo`L0ooD0B`006Ol50?oe04/0oooo1@3om@1m000Io`@0ooD06@3oool3003o/`X0oooo0009
0?ooo`<00?ncE`3oool80?oe04X001Wo103om@1:0?ooo`D0ooD0O`006Ol40?oe01P0oooo0`00ok<:
0?ooo`002@3oool3003o/eP0oooo2@3om@18000Io`D0ooD0B@3oool40?oe080001Wo1@3om@0G0?oo
o`<00?nc2P3oool000T0oooo0`00ok=I0?ooo`X0ooD0A`006Ol40?oe04P0oooo103om@22000Io`D0
ooD05P3oool3003o/`X0oooo00090?ooo`<00?ncF`3oool:0?oe04D001Wo103om@180?ooo`@0ooD0
PP006Ol60?oe01D0oooo0`00ok<:0?ooo`002@3oool3003o/ed0oooo2@3om@14000Io`@0ooD0A`3o
ool40?oe08@001Wo1@3om@0E0?ooo`<00?nc2P3oool000T0oooo0`00ok=O0?ooo`T0ooD0@P006Ol4
0?oe04H0oooo1@3om@25000Io`@0ooD05@3oool3003o/`X0oooo00090?ooo`<00?ncH@3oool90?oe
040001Wo103om@150?ooo`D0ooD0QP006Ol40?oe01D0oooo0`00ok<:0?ooo`002@3oool3003o/f@0
oooo1`3om@0o000Io`D0ooD0@`3oool50?oe08L001Wo103om@0E0?ooo`<00?nc2P3oool000T0oooo
0`00ok=V0?ooo`L0ooD0?P006Ol40?oe04<0oooo1@3om@27000Io`@0ooD05@3oool3003o/`X0oooo
00090?ooo`<00?ncJ03oool60?oe03d001Wo1@3om@110?ooo`D0ooD0R0006Ol50?oe01@0oooo0`00
ok<:0?ooo`002@3oool3003o/fT0oooo1`3om@0k000Io`D0ooD0@03oool50?oe08X001Wo103om@0D
0?ooo`<00?nc2P3oool000T0oooo0`00ok=[0?ooo`H0ooD0>`006Ol40?oe0400oooo1@3om@2:000I
o`@0ooD0503oool3003o/`X0oooo00090?ooo`<00?ncK03oool60?oe03X001Wo1@3om@0n0?ooo`D0
ooD0R`006Ol40?oe01@0oooo0`00ok<:0?ooo`002@3oool3003o/fd0oooo1P3om@0j000Io`@0ooD0
?@3oool50?oe08`001Wo1@3om@0C0?ooo`<00?nc2P3oool000T0oooo0`00ok=^0?ooo`L0ooD0>@00
6Ol40?oe03/0oooo1P3om@2=000Io`@0ooD04`3oool3003o/`X0oooo00090?ooo`<00?ncK`3oool7
0?oe03P001Wo103om@0k0?ooo`D0ooD0SP006Ol50?oe0180oooo0`00ok<:0?ooo`002@3oool3003o
/g00oooo1`3om@0h000Io`@0ooD0>@3oool50?oe08l001Wo1@3om@0B0?ooo`<00?nc2P3oool000T0
oooo0`00ok=b0?ooo`L0ooD0=P006Ol50?oe03P0oooo103om@2A000Io`D0ooD04@3oool3003o/`X0
oooo00090?ooo`<00?ncL`3oool70?oe03H001Wo103om@0g0?ooo`D0ooD0T@006Ol50?oe0140oooo
0`00ok<:0?ooo`002@3oool3003o/g@0oooo1`3om@0e000Io`@0ooD0=`3oool50?oe098001Wo103o
m@0A0?ooo`<00?nc2P3oool000T0oooo0`00ok=f0?ooo`H0ooD0=0006Ol40?oe03H0oooo1@3om@2C
000Io`@0ooD04@3oool3003o/`X0oooo00090?ooo`<00?ncM`3oool60?oe03<001Wo103om@0f0?oo
o`D0ooD0T`006Ol40?oe0140oooo0`00ok<:0?ooo`002@3oool3003o/gP0oooo1P3om@0b000Io`@0
ooD0=@3oool50?oe09@001Wo103om@0A0?ooo`<00?nc2P3oool000T0oooo0`00ok=i0?ooo`H0ooD0
<@006Ol40?oe03D0oooo1@3om@2D000Io`@0ooD04@3oool3003o/`X0oooo00090?ooo`<00?ncNP3o
ool60?oe030001Wo1@3om@0d0?ooo`@0ooD0U@006Ol40?oe0140oooo0`00ok<:0?ooo`002@3oool3
003o/g/0oooo1P3om@0`000Io`@0ooD0<`3oool40?oe09H001Wo103om@0A0?ooo`<00?nc2P3oool0
00T0oooo0`00ok=l0?ooo`H0ooD0;`006Ol50?oe0340oooo1@3om@2F000Io`@0ooD04@3oool3003o
/`X0oooo00090?ooo`<00?ncO@3oool60?oe02h001Wo1@3om@0a0?ooo`@0ooD0U`006Ol40?oe0140
oooo0`00ok<:0?ooo`002@3oool3003o/gh0oooo1P3om@0^000Io`@0ooD0<03oool40?oe09P001Wo
103om@0A0?ooo`<00?nc2P3oool000T0oooo0`00ok=o0?ooo`D0ooD0;P006Ol40?oe02l0oooo1@3o
m@2H000Io`@0ooD04@3oool3003o/`X0oooo00090?ooo`<00?ncP03oool40?oe02h001Wo103om@0^
0?ooo`D0ooD0V@006Ol40?oe0140oooo0`00ok<:0?ooo`002@3oool3003o/h00oooo103om@0^000I
o`@0ooD0;P3oool40?oe09X001Wo103om@0A0?ooo`<00?nc2P3oool000T0oooo0`00ok>00?ooo`@0
ooD0;P006Ol40?oe02d0oooo1@3om@2J000Io`@0ooD04@3oool3003o/`X0oooo00090?ooo`<00?nc
P03oool40?oe02h001Wo1@3om@0[0?ooo`D0ooD0V`006Ol40?oe0140oooo0`00ok<:0?ooo`002@3o
ool3003o/h00oooo103om@0_000Io`@0ooD0:`3oool40?oe09`001Wo103om@0A0?ooo`<00?nc2P3o
ool000T0oooo0`00ok>00?ooo`@0ooD0<0006Ol40?oe02T0oooo1@3om@2L000Io`@0ooD04@3oool3
003o/`X0oooo00090?ooo`<00?ncP03oool40?oe030001Wo103om@0X0?ooo`D0ooD0W@006Ol40?oe
0140oooo0`00ok<:0?ooo`002@3oool3003o/h00oooo1@3om@0`000Io`@0ooD09`3oool40?oe09h0
01Wo103om@0A0?ooo`<00?nc2P3oool000T0oooo0`00ok>10?ooo`@0ooD0<0006Ol50?oe02D0oooo
103om@2O000Io`@0ooD04@3oool3003o/`X0oooo00090?ooo`<00?ncP@3oool40?oe034001Wo103o
m@0T0?ooo`D0ooD0W`006Ol40?oe0140oooo0`00ok<:0?ooo`002@3oool3003o/h40oooo103om@0a
000Io`@0ooD0903oool40?oe0:0001Wo103om@0A0?ooo`<00?nc2P3oool000T0oooo0`00ok>10?oo
o`@0ooD0<@006Ol40?oe02<0oooo103om@2Q000Io`@0ooD04@3oool3003o/`X0oooo00090?ooo`<0
0?ncP@3oool40?oe034001Wo103om@0R0?ooo`D0ooD0X@006Ol40?oe0140oooo0`00ok<:0?ooo`00
2@3oool3003o/h40oooo103om@0b000Io`@0ooD0803oool50?oe0:8001Wo103om@0A0?ooo`<00?nc
2P3oool000T0oooo0`00ok>10?ooo`@0ooD0<P006Ol40?oe01l0oooo1@3om@2S000Io`@0ooD04@3o
ool3003o/`X0oooo00090?ooo`<00?ncP@3oool40?oe03<001Wo103om@0L0?ooo`L0ooD0X`006Ol4
0?oe0140oooo0`00ok<:0?ooo`002@3oool3003o/h40oooo103om@0c000Io`@0ooD06@3oool90?oe
0:@001Wo103om@0A0?ooo`<00?nc2P3oool000T0oooo0`00ok>10?ooo`@0ooD0=0006Ol40?oe01@0
oooo303om@2U000Io`@0ooD04@3oool3003o/`X0oooo00090?ooo`<00?ncP@3oool40?oe03@001Wo
103om@0@0?ooo`l0ooD0YP006Ol40?oe0140oooo0`00ok<:0?ooo`002@3oool3003o/h40oooo103o
m@0e000Io`@0ooD03P3oool=0?oe0:T001Wo103om@0A0?ooo`<00?nc2P3oool000T0oooo0`00ok>1
0?ooo`@0ooD0=@006Ol40?oe00`0oooo303om@2/000Io`@0ooD04@3oool3003o/`X0oooo00090?oo
o`<00?ncP@3oool40?oe03H001Wo1@3om@080?ooo`X0ooD0/0006Ol40?oe0140oooo0`00ok<:0?oo
o`002@3oool3003o/h40oooo103om@0f000Io`L0ooD0103oool80?oe0;@001Wo103om@0A0?ooo`<0
0?nc2P3oool000T0oooo0`00ok>10?ooo`@0ooD0=`006Ol@0?oe0;H001Wo103om@0A0?ooo`<00?nc
2P3oool000T0oooo0`00ok>10?ooo`@0ooD0=`006Ol>0?oe0;P001Wo103om@0A0?ooo`<00?nc2P3o
ool000T0oooo0`00ok>10?ooo`@0ooD0>@006Ol:0?oe0;X001Wo103om@0A0?ooo`<00?nc2P3oool0
00T0oooo0`00ok>10?ooo`@0ooD0>`006Ol70?oe0;/001Wo103om@0A0?ooo`<00?nc2P3oool000T0
oooo0`00ok>10?ooo`@0ooD0o@006Ol40?oe0140oooo0`00ok<:0?ooo`002@3oool3003o/h00oooo
1@3om@3m000Io`@0ooD04@3oool3003o/`X0oooo00090?ooo`<00?ncP03oool50?oe0?d001Wo103o
m@0A0?ooo`<00?nc2P3oool000T0oooo0`00ok=o0?ooo`D0ooD0oP006Ol40?oe0140oooo0`00ok<:
0?ooo`002@3oool3003o/gl0oooo1@3om@3n000Io`@0ooD04@3oool3003o/`X0oooo00090?ooo`<0
0?ncO`3oool40?oe0?l001Wo103om@0A0?ooo`<00?nc2P3oool000T0oooo0`00ok=o0?ooo`@0ooD0
o`006Ol40?oe0140oooo0`00ok<:0?ooo`002@3oool3003o/gl0oooo103om@3o000Io`@0ooD04@3o
ool3003o/`X0oooo00090?ooo`<00?ncO`3oool40?oe0?l001Wo103om@0A0?ooo`<00?nc2P3oool0
00T0oooo0`00ok=o0?ooo`@0ooD0oP006Ol50?oe0140oooo0`00ok<:0?ooo`002@3oool3003o/gl0
oooo103om@3n000Io`@0ooD04P3oool3003o/`X0oooo00090?ooo`<00?ncO`3oool40?oe0?d001Wo
1@3om@0B0?ooo`<00?nc2P3oool000T0oooo0`00ok=n0?ooo`D0ooD0o@006Ol50?oe0180oooo0`00
ok<:0?ooo`002@3oool3003o/gh0oooo103om@3n000Io`@0ooD04`3oool3003o/`X0oooo00090?oo
o`<00?ncOP3oool40?oe0?d001Wo1@3om@0C0?ooo`<00?nc2P3oool000T0oooo0`00ok=m0?ooo`D0
ooD0o@006Ol40?oe01@0oooo0`00ok<:0?ooo`002@3oool3003o/g`0oooo1@3om@3n000Io`@0ooD0
503oool3003o/`X0oooo00090?ooo`<00?ncN`3oool60?oe0?h001Wo103om@0D0?ooo`<00?nc2P3o
ool000T0oooo0`00ok=k0?ooo`D0ooD0o`006Ol40?oe01@0oooo0`00ok<:0?ooo`002@3oool3003o
/gX0oooo1@3om@3o000Io`D0ooD0503oool3003o/`X0oooo00090?ooo`<00?ncNP3oool40?oe0?l0
01Wo1@3om@0E0?ooo`<00?nc2P3oool000T0oooo0`00ok=j0?ooo`@0ooD0oP006Ol60?oe01D0oooo
0`00ok<:0?ooo`002@3oool3003o/gX0oooo103om@3n000Io`D0ooD05P3oool3003o/`X0oooo0009
0?ooo`<00?ncNP3oool40?oe0?d001Wo1@3om@0G0?ooo`<00?nc2P3oool000T0oooo0`00ok=i0?oo
o`D0ooD0o@006Ol40?oe01P0oooo0`00ok<:0?ooo`002@3oool3003o/gP0oooo1@3om@3m000Io`D0
ooD0603oool3003o/`X0oooo00090?ooo`<00?ncM`3oool60?oe0?d001Wo1@3om@0H0?ooo`<00?nc
2P3oool000T0oooo0`00ok=g0?ooo`D0ooD0o@006Ol50?oe01T0oooo0`00ok<:0?ooo`002@3oool3
003o/gH0oooo1@3om@3n000Io`D0ooD06@3oool3003o/`X0oooo00090?ooo`<00?ncM@3oool50?oe
0?h001Wo1@3om@0J0?ooo`<00?nc2P3oool000T0oooo0`00ok=d0?ooo`H0ooD0o@006Ol60?oe01X0
oooo0`00ok<:0?ooo`002@3oool3003o/g<0oooo1P3om@3m000Io`H0ooD06`3oool3003o/`X0oooo
00090?ooo`<00?ncLP3oool60?oe0?h001Wo1@3om@0L0?ooo`<00?nc2P3oool000T0oooo0`00ok=a
0?ooo`H0ooD0oP006Ol50?oe01d0oooo0`00ok<:0?ooo`002@3oool3003o/g00oooo1P3om@3n000I
o`D0ooD07P3oool3003o/`X0oooo00090?ooo`<00?ncK`3oool60?oe0?h001Wo1P3om@0N0?ooo`<0
0?nc2P3oool000T0oooo0`00ok=^0?ooo`H0ooD0oP006Ol60?oe01l0oooo0`00ok<:0?ooo`002@3o
ool3003o/fd0oooo1P3om@3n000Io`H0ooD0803oool3003o/`X0oooo00090?ooo`<00?ncK03oool6
0?oe0?h001Wo1P3om@0Q0?ooo`<00?nc2P3oool000T0oooo0`00ok=[0?ooo`H0ooD0oP006Ol60?oe
0280oooo0`00ok<:0?ooo`002@3oool3003o/fX0oooo1P3om@3o000Io`D0ooD08`3oool3003o/`X0
oooo00090?ooo`<00?ncJ@3oool60?oe0?l001Wo1@3om@0T0?ooo`<00?nc2P3oool000T0oooo0`00
ok=X0?ooo`H0ooD0o`006Ol1000Io`@0ooD09@3oool3003o/`X0oooo00090?ooo`<00?ncI`3oool6
0?oe0?l001Wo0@006Ol40?oe02H0oooo0`00ok<:0?ooo`002@3oool3003o/fH0oooo1P3om@3o000I
o`8001Wo103om@0V0?ooo`<00?nc2P3oool000T0oooo0`00ok=U0?ooo`H0ooD0o0006Ol20?oe00<0
01Wo103om@0W0?ooo`<00?nc2P3oool000T0oooo0`00ok=T0?ooo`H0ooD0o@006Ol90?oe02L0oooo
0`00ok<:0?ooo`002@3oool3003o/f<0oooo1P3om@3m000Io`T0ooD0:03oool3003o/`X0oooo0009
0?ooo`<00?ncH@3oool70?oe0?h001Wo2@3om@0X0?ooo`<00?nc2P3oool000T0oooo0`00ok=P0?oo
o`L0ooD0o`006Ol80?oe02T0oooo0`00ok<:0?ooo`002@3oool3003o/el0oooo1`3om@3o000Io`P0
ooD0:P3oool3003o/`X0oooo00090?ooo`<00?ncGP3oool60?oe0?l001Wo0P006Ol40?oe0080oooo
0P3om@0Z0?ooo`<00?nc2P3oool000T0oooo0`00ok=M0?ooo`H0ooD0o`006Ol3000Io`@0ooD0;P3o
ool3003o/`X0oooo00090?ooo`<00?ncF`3oool70?oe0?l001Wo0`006Ol50?oe02h0oooo0`00ok<:
0?ooo`002@3oool3003o/eX0oooo1`3om@1=000IobL0ooD0S`006Ol40?oe02l0oooo0`00ok<:0?oo
o`002@3oool3003o/eT0oooo1`3om@1;000Iobh0ooD0RP006Ol40?oe0300oooo0`00ok<:0?ooo`00
2@3oool3003o/eT0oooo1@3om@1;000Ioc<0ooD0Q`006Ol40?oe0300oooo0`00ok<:0?ooo`002@3o
ool3003o/eL0oooo1P3om@1:000IocP0ooD0P`006Ol40?oe0340oooo0`00ok<:0?ooo`002@3oool3
003o/eH0oooo1P3om@1;000Io`P0ooD09P3oool<0?oe080001Wo1@3om@0a0?ooo`<00?nc2P3oool0
00T0oooo0`00ok=D0?ooo`L0ooD0B`006Ol70?oe02/0oooo303om@1m000Io`@0ooD0<P3oool3003o
/`X0oooo00090?ooo`<00?ncD`3oool60?oe04`001Wo1P3om@0`0?ooo`X0ooD0O0006Ol40?oe0380
oooo0`00ok<:0?ooo`002@3oool3003o/e40oooo1`3om@1<000Io`H0ooD0<`3oool90?oe07/001Wo
103om@0b0?ooo`<00?nc2P3oool000T0oooo0`00ok=@0?ooo`H0ooD0CP006Ol50?oe03H0oooo2@3o
m@1h000Io`@0ooD0<`3oool3003o/`X0oooo00090?ooo`<00?ncCP3oool70?oe04h001Wo1@3om@0i
0?ooo`P0ooD0M`006Ol40?oe03<0oooo0`00ok<:0?ooo`002@3oool3003o/d/0oooo203om@1?000I
o`D0ooD0?@3oool60?oe07D001Wo103om@0d0?ooo`<00?nc2P3oool000T0oooo0`00ok=80?ooo`X0
ooD0D0006Ol50?oe03l0oooo1P3om@1c000Io`@0ooD0=03oool3003o/`X0oooo00090?ooo`<00?nc
AP3oool:0?oe054001Wo1@3om@110?ooo`H0ooD0L@006Ol40?oe03D0oooo0`00ok<:0?ooo`002@3o
ool3003o/d<0oooo303om@1A000Io`D0ooD0@`3oool60?oe070001Wo103om@0e0?ooo`<00?nc2P3o
ool000T0oooo0`00ok=10?ooo`/0ooD0D`006Ol60?oe04D0oooo1@3om@1_000Io`@0ooD0=@3oool3
003o/`X0oooo00090?ooo`<00?nc@03oool90?oe05D001Wo1P3om@160?ooo`D0ooD0K`006Ol40?oe
03D0oooo0`00ok<:0?ooo`002@3oool3003o/cl0oooo203om@1G000Io`D0ooD0B03oool50?oe06h0
01Wo103om@0e0?ooo`<00?nc2P3oool000T0oooo0`00ok<n0?ooo`H0ooD0F@006Ol50?oe04X0oooo
103om@1]000Io`D0ooD0=@3oool3003o/`X0oooo00090?ooo`<00?nc?@3oool60?oe05X001Wo103o
m@1<0?ooo`@0ooD0K0006Ol40?oe03H0oooo0`00ok<:0?ooo`002@3oool3003o/c`0oooo1P3om@1J
000Io`D0ooD0C03oool40?oe06`001Wo103om@0f0?ooo`<00?nc2P3oool000T0oooo0`00ok<j0?oo
o`L0ooD0F`006Ol50?oe04d0oooo103om@1[000Io`@0ooD0=P3oool3003o/`X0oooo00090?ooo`<0
0?nc>@3oool70?oe05/001Wo1@3om@1>0?ooo`D0ooD0JP006Ol40?oe03H0oooo0`00ok<:0?ooo`00
2@3oool3003o/cP0oooo1`3om@1L000Io`D0ooD0C`3oool40?oe06X001Wo103om@0f0?ooo`<00?nc
2P3oool000T0oooo0`00ok<g0?ooo`H0ooD0GP006Ol40?oe0500oooo103om@1Z000Io`@0ooD0=P3o
ool3003o/`X0oooo00090?ooo`<00?nc=P3oool60?oe05h001Wo1@3om@1@0?ooo`@0ooD0JP006Ol4
0?oe03H0oooo0`00ok<:0?ooo`002@3oool3003o/cD0oooo1P3om@1O000Io`@0ooD0D@3oool40?oe
06X001Wo103om@0f0?ooo`<00?nc2P3oool000T0oooo0`00ok<d0?ooo`H0ooD0H0006Ol40?oe0540
oooo103om@1Z000Io`@0ooD0=P3oool3003o/`X0oooo00090?ooo`<00?nc=03oool50?oe060001Wo
1@3om@1A0?ooo`@0ooD0JP006Ol40?oe03H0oooo0`00ok<:0?ooo`002@3oool3003o/c<0oooo103o
m@1R000Io`@0ooD0DP3oool40?oe06X001Wo103om@0f0?ooo`<00?nc2P3oool000T0oooo0`00ok<c
0?ooo`@0ooD0HP006Ol40?oe0580oooo103om@1Z000Io`@0ooD0=P3oool3003o/`X0oooo00090?oo
o`<00?nc<P3oool40?oe06<001Wo103om@1B0?ooo`@0ooD0JP006Ol40?oe03H0oooo0`00ok<:0?oo
o`002@3oool3003o/c80oooo103om@1R000Io`@0ooD0D`3oool40?oe06X001Wo103om@0f0?ooo`<0
0?nc2P3oool000T0oooo0`00ok<a0?ooo`@0ooD0H`006Ol40?oe05<0oooo103om@1Z000Io`@0ooD0
=P3oool3003o/`X0oooo00090?ooo`<00?nc<@3oool40?oe068001Wo103om@1D0?ooo`@0ooD0JP00
6Ol40?oe03H0oooo0`00ok<:0?ooo`002@3oool3003o/c00oooo103om@1S000Io`@0ooD0E03oool4
0?oe06X001Wo103om@0f0?ooo`<00?nc2P3oool000T0oooo0`00ok<`0?ooo`@0ooD0HP006Ol40?oe
05D0oooo103om@1Z000Io`@0ooD0=P3oool3003o/`X0oooo00090?ooo`<00?nc;P3oool50?oe06<0
01Wo103om@1E0?ooo`@0ooD0JP006Ol40?oe03H0oooo0`00ok<:0?ooo`002@3oool3003o/bd0oooo
1P3om@1R000Io`@0ooD0EP3oool40?oe06X001Wo103om@0f0?ooo`<00?nc2P3oool000T0oooo0`00
ok</0?ooo`H0ooD0H`006Ol40?oe05H0oooo103om@1Z000Io`@0ooD0=P3oool3003o/`X0oooo0009
0?ooo`<00?nc:`3oool60?oe06<001Wo103om@1G0?ooo`@0ooD0JP006Ol40?oe03H0oooo0`00ok<:
0?ooo`002@3oool3003o/bX0oooo1P3om@1T000Io`@0ooD0E`3oool40?oe06X001Wo103om@0f0?oo
o`<00?nc2P3oool000T0oooo0`00ok<Y0?ooo`H0ooD0I0006Ol40?oe05P0oooo103om@1Z000Io`@0
ooD0=P3oool3003o/`X0oooo00090?ooo`<00?nc:03oool60?oe06D001Wo103om@1H0?ooo`@0ooD0
JP006Ol50?oe03D0oooo0`00ok<:0?ooo`002@3oool3003o/bL0oooo1P3om@1U000Io`@0ooD0F@3o
ool40?oe06/001Wo103om@0e0?ooo`<00?nc2P3oool000T0oooo0`00ok<V0?ooo`H0ooD0IP006Ol4
0?oe05T0oooo103om@1[000Io`@0ooD0=@3oool3003o/`X0oooo00090?ooo`<00?nc9P3oool50?oe
06L001Wo103om@1I0?ooo`@0ooD0J`006Ol40?oe03D0oooo0`00ok<:0?ooo`002@3oool3003o/bD0
oooo1@3om@1X000Io`@0ooD0F@3oool40?oe06/001Wo103om@0e0?ooo`<00?nc2P3oool000T0oooo
0`00ok<U0?ooo`@0ooD0J@006Ol40?oe05T0oooo103om@1/000Io`@0ooD0=03oool3003o/`X0oooo
00090?ooo`<00?nc9@3oool40?oe06P001Wo1@3om@1H0?ooo`@0ooD0K@006Ol40?oe03@0oooo0`00
ok<:0?ooo`002@3oool3003o/bD0oooo103om@1X000Io`@0ooD0F@3oool40?oe06h001Wo103om@0c
0?ooo`<00?nc2P3oool000T0oooo0`00ok<U0?ooo`@0ooD0J0006Ol40?oe05P0oooo103om@1_000I
o`@0ooD0<`3oool3003o/`X0oooo00090?ooo`<00?nc9@3oool40?oe06P001Wo103om@1H0?ooo`@0
ooD0L0006Ol40?oe0380oooo0`00ok<:0?ooo`002@3oool3003o/b@0oooo103om@1Y000Io`@0ooD0
E`3oool40?oe074001Wo103om@0b0?ooo`<00?nc2P3oool000T0oooo0`00ok<T0?ooo`@0ooD0J@00
6Ol40?oe05L0oooo103om@1a000Io`@0ooD0<P3oool3003o/`X0oooo00090?ooo`<00?nc8`3oool4
0?oe06X001Wo103om@1F0?ooo`@0ooD0LP006Ol50?oe0340oooo0`00ok<:0?ooo`002@3oool3003o
/b<0oooo103om@1Z000Io`@0ooD0EP3oool40?oe07<001Wo103om@0a0?ooo`<00?nc2P3oool000T0
oooo0`00ok<R0?ooo`@0ooD0J`006Ol40?oe05D0oooo103om@1d000Io`@0ooD0<@3oool3003o/`X0
oooo00090?ooo`<00?nc8P3oool40?oe06/001Wo103om@1E0?ooo`@0ooD0M0006Ol50?oe0300oooo
0`00ok<:0?ooo`002@3oool3003o/b80oooo103om@1[000Io`@0ooD0E03oool40?oe07H001Wo103o
m@0`0?ooo`<00?nc2P3oool000T0oooo0`00ok<R0?ooo`@0ooD0J`006Ol40?oe05<0oooo1@3om@1f
000Io`@0ooD0<03oool3003o/`X0oooo00090?ooo`<00?nc8P3oool40?oe06/001Wo103om@1B0?oo
o`D0ooD0M`006Ol40?oe0300oooo0`00ok<:0?ooo`002@3oool3003o/b80oooo103om@1[000Io`@0
ooD0DP3oool40?oe07T001Wo103om@0_0?ooo`<00?nc2P3oool000T0oooo0`00ok<R0?ooo`@0ooD0
JP006Ol50?oe0540oooo1@3om@1i000Io`@0ooD0;`3oool3003o/`X0oooo00090?ooo`<00?nc8P3o
ool40?oe06X001Wo1@3om@1@0?ooo`D0ooD0N`006Ol40?oe02h0oooo0`00ok<:0?ooo`002@3oool3
003o/b80oooo103om@1Y000Io`D0ooD0D@3oool40?oe07`001Wo103om@0^0?ooo`<00?nc2P3oool0
00T0oooo0`00ok<R0?ooo`@0ooD0J@006Ol50?oe0500oooo103om@1n000Io`@0ooD0;@3oool3003o
/`X0oooo00090?ooo`<00?nc8P3oool40?oe06P001Wo1@3om@1A0?ooo`@0ooD0OP006Ol50?oe02`0
oooo0`00ok<:0?ooo`002@3oool3003o/b80oooo103om@1X000Io`D0ooD0C`3oool50?oe080001Wo
1@3om@0[0?ooo`<00?nc2P3oool000T0oooo0`00ok<R0?ooo`@0ooD0J0006Ol40?oe04l0oooo1P3o
m@20000Io`H0ooD0:P3oool3003o/`X0oooo00090?ooo`<00?nc8P3oool40?oe06P001Wo103om@1>
0?ooo`H0ooD0PP006Ol60?oe02T0oooo0`00ok<:0?ooo`002@3oool3003o/b80oooo103om@1X000I
o`@0ooD0C@3oool60?oe08@001Wo1P3om@0X0?ooo`<00?nc2P3oool000T0oooo0`00ok<R0?ooo`@0
ooD0J0006Ol40?oe04`0oooo1P3om@26000Io`H0ooD09`3oool3003o/`X0oooo00090?ooo`<00?nc
8P3oool40?oe06P001Wo103om@1;0?ooo`H0ooD0R0006Ol60?oe02H0oooo0`00ok<:0?ooo`002@3o
ool3003o/b80oooo103om@1X000Io`@0ooD0B@3oool70?oe08X001Wo1P3om@0U0?ooo`<00?nc2P3o
ool000T0oooo0`00ok<R0?ooo`@0ooD0J0006Ol40?oe04P0oooo1`3om@2<000Io`H0ooD0903oool3
003o/`X0oooo00090?ooo`<00?nc8P3oool40?oe06P001Wo103om@160?ooo`P0ooD0SP006Ol60?oe
02<0oooo0`00ok<:0?ooo`002@3oool3003o/b80oooo103om@1X000Io`@0ooD0A@3oool70?oe0940
01Wo1P3om@0R0?ooo`<00?nc2P3oool000T0oooo0`00ok<R0?ooo`@0ooD0J0006Ol40?oe04<0oooo
1`3om@2D000Io`H0ooD08@3oool3003o/`X0oooo00090?ooo`<00?nc8P3oool40?oe06P001Wo103o
m@120?ooo`H0ooD0U`006Ol60?oe0200oooo0`00ok<:0?ooo`002@3oool3003o/b80oooo103om@1X
000Io`@0ooD0@03oool70?oe09T001Wo1P3om@0O0?ooo`<00?nc2P3oool000T0oooo0`00ok<R0?oo
o`@0ooD0J0006Ol40?oe03l0oooo1P3om@2L000Io`H0ooD07P3oool3003o/`X0oooo00090?ooo`<0
0?nc8P3oool40?oe06P001Wo103om@0n0?ooo`H0ooD0WP006Ol60?oe01d0oooo0`00ok<:0?ooo`00
2@3oool3003o/b80oooo103om@1X000Io`@0ooD0?@3oool60?oe0:0001Wo1P3om@0L0?ooo`<00?nc
2P3oool000T0oooo0`00ok<R0?ooo`D0ooD0I`006Ol40?oe03`0oooo1P3om@2R000Io`H0ooD06`3o
ool3003o/`X0oooo00090?ooo`<00?nc8`3oool40?oe06L001Wo103om@0j0?ooo`L0ooD0Y0006Ol6
0?oe01X0oooo0`00ok<:0?ooo`002@3oool3003o/b<0oooo103om@1W000Io`@0ooD0>03oool70?oe
0:L001Wo1P3om@0I0?ooo`<00?nc2P3oool000T0oooo0`00ok<S0?ooo`@0ooD0I`006Ol40?oe03L0
oooo1`3om@2Y000Io`H0ooD0603oool3003o/`X0oooo00090?ooo`<00?nc8`3oool40?oe06L001Wo
103om@0f0?ooo`H0ooD0D0006Ol=0?oe04l001Wo1P3om@0G0?ooo`<00?nc2P3oool000T0oooo0`00
ok<S0?ooo`@0ooD0I`006Ol40?oe03H0oooo103om@1A000Ioa<0ooD0B`006Ol60?oe01H0oooo0`00
ok<:0?ooo`002@3oool3003o/b<0oooo103om@1W000Io`@0ooD0=@3oool40?oe054001Wo5`3om@19
000Io`H0ooD05@3oool3003o/`X0oooo00090?ooo`<00?nc8`3oool40?oe06L001Wo103om@0d0?oo
o`D0ooD0D0006OlJ0?oe04P001Wo1P3om@0D0?ooo`<00?nc2P3oool000T0oooo0`00ok<S0?ooo`@0
ooD0I`006Ol40?oe03@0oooo103om@1@000Io`H0ooD02P3oool=0?oe04L001Wo1P3om@0C0?ooo`<0
0?nc2P3oool000T0oooo0`00ok<T0?ooo`@0ooD0IP006Ol40?oe03<0oooo1@3om@1?000Io`H0ooD0
403oool:0?oe04H001Wo1P3om@0B0?ooo`<00?nc2P3oool000T0oooo0`00ok<T0?ooo`@0ooD0IP00
6Ol40?oe0380oooo1@3om@1?000Io`H0ooD04`3oool:0?oe04D001Wo1@3om@0B0?ooo`<00?nc2P3o
ool000T0oooo0`00ok<U0?ooo`@0ooD0I@006Ol40?oe0340oooo1P3om@1>000Io`H0ooD05P3oool9
0?oe04D001Wo1@3om@0A0?ooo`<00?nc2P3oool000T0oooo0`00ok<U0?ooo`D0ooD0I0006Ol40?oe
0340oooo1@3om@1>000Io`H0ooD06@3oool80?oe04D001Wo103om@0A0?ooo`<00?nc2P3oool000T0
oooo0`00ok<V0?ooo`@0ooD0I0006Ol40?oe0300oooo1@3om@1>000Io`H0ooD07@3oool70?oe04@0
01Wo103om@0@0?ooo`<00?nc2P3oool000T0oooo0`00ok<V0?ooo`@0ooD0I0006Ol40?oe0300oooo
103om@1>000Io`H0ooD07`3oool70?oe04<001Wo103om@0@0?ooo`<00?nc2P3oool000T0oooo0`00
ok<V0?ooo`@0ooD0I0006Ol40?oe0300oooo103om@1>000Io`D0ooD08@3oool70?oe04<001Wo103o
m@0?0?ooo`<00?nc2P3oool000T0oooo0`00ok<V0?ooo`@0ooD0I0006Ol40?oe0300oooo103om@1=
000Io`D0ooD0903oool60?oe048001Wo1@3om@0>0?ooo`<00?nc2P3oool000T0oooo0`00ok<V0?oo
o`D0ooD0H`006Ol40?oe02l0oooo1@3om@1<000Io`D0ooD09P3oool60?oe048001Wo1@3om@0=0?oo
o`<00?nc2P3oool000T0oooo0`00ok<W0?ooo`@0ooD0H`006Ol40?oe02l0oooo103om@1<000Io`H0
ooD09`3oool70?oe040001Wo1P3om@0<0?ooo`<00?nc2P3oool000T0oooo0`00ok<W0?ooo`@0ooD0
H`006Ol40?oe02h0oooo103om@1<000Io`H0ooD0:P3oool60?oe040001Wo1@3om@0<0?ooo`<00?nc
2P3oool000T0oooo0`00ok<W0?ooo`D0ooD0HP006Ol40?oe02h0oooo103om@1<000Io`D0ooD0;03o
ool70?oe03l001Wo103om@0<0?ooo`<00?nc2P3oool000T0oooo0`00ok<X0?ooo`@0ooD0HP006Ol4
0?oe02d0oooo103om@1<000Io`D0ooD0;`3oool60?oe03h001Wo103om@0<0?ooo`<00?nc2P3oool0
00T0oooo0`00ok<X0?ooo`@0ooD0HP006Ol40?oe02`0oooo1@3om@1<000Io`@0ooD0<@3oool60?oe
03d001Wo103om@0<0?ooo`<00?nc2P3oool000T0oooo0`00ok<X0?ooo`D0ooD0H@006Ol40?oe02`0
oooo103om@1=000Io`@0ooD0<`3oool50?oe03`001Wo103om@0<0?ooo`<00?nc2P3oool000T0oooo
0`00ok<Y0?ooo`@0ooD0H@006Ol40?oe02`0oooo103om@1<000Io`D0ooD0<`3oool60?oe03/001Wo
1@3om@0;0?ooo`<00?nc2P3oool000T0oooo0`00ok<Y0?ooo`D0ooD0H0006Ol40?oe02`0oooo103o
m@1<000Io`@0ooD0=@3oool70?oe03X001Wo103om@0;0?ooo`<00?nc2P3oool000T0oooo0`00ok<Y
0?ooo`D0ooD0H0006Ol40?oe02`0oooo103om@1<000Io`@0ooD0=`3oool60?oe03T001Wo103om@0;
0?ooo`<00?nc2P3oool000T0oooo0`00ok<Z0?ooo`D0ooD0G`006Ol40?oe02`0oooo103om@1;000I
o`D0ooD0>03oool70?oe03L001Wo103om@0;0?ooo`<00?nc2P3oool000T0oooo0`00ok<Z0?ooo`D0
ooD0G`006Ol40?oe02`0oooo103om@1;000Io`@0ooD0>`3oool60?oe03H001Wo103om@0;0?ooo`<0
0?nc2P3oool000T0oooo0`00ok<[0?ooo`@0ooD0G`006Ol40?oe02`0oooo103om@1;000Io`@0ooD0
?03oool70?oe03@001Wo103om@0;0?ooo`<00?nc2P3oool000T0oooo0`00ok<[0?ooo`D0ooD0GP00
6Ol40?oe02`0oooo103om@1;000Io`@0ooD0?P3oool60?oe03<001Wo103om@0;0?ooo`<00?nc2P3o
ool000T0oooo0`00ok</0?ooo`@0ooD0GP006Ol40?oe02`0oooo103om@1;000Io`@0ooD0?`3oool6
0?oe038001Wo103om@0;0?ooo`<00?nc2P3oool000T0oooo0`00ok<]0?ooo`@0ooD0G@006Ol40?oe
02`0oooo103om@1;000Io`@0ooD0@@3oool40?oe038001Wo103om@0;0?ooo`<00?nc2P3oool000T0
oooo0`00ok<]0?ooo`@0ooD0G@006Ol40?oe02`0oooo103om@1:000Io`D0ooD0@P3oool40?oe0340
01Wo103om@0;0?ooo`<00?nc2P3oool000T0oooo0`00ok<^0?ooo`@0ooD0G0006Ol40?oe02`0oooo
103om@1:000Io`@0ooD0@`3oool40?oe034001Wo103om@0;0?ooo`<00?nc2P3oool000T0oooo0`00
ok<^0?ooo`D0ooD0F`006Ol40?oe02`0oooo103om@1:000Io`@0ooD0A03oool40?oe030001Wo103o
m@0;0?ooo`<00?nc2P3oool000T0oooo0`00ok<_0?ooo`@0ooD0FP006Ol40?oe02d0oooo103om@1:
000Io`@0ooD0A03oool50?oe02l001Wo103om@0;0?ooo`<00?nc2P3oool000T0oooo0`00ok<`0?oo
o`@0ooD0F@006Ol40?oe02d0oooo103om@1:000Io`@0ooD0A@3oool50?oe02h001Wo103om@0;0?oo
o`<00?nc2P3oool000T0oooo0`00ok<`0?ooo`@0ooD0F0006Ol40?oe02h0oooo103om@1:000Io`@0
ooD0AP3oool50?oe02d001Wo103om@0;0?ooo`<00?nc2P3oool000T0oooo0`00ok<a0?ooo`@0ooD0
E`006Ol40?oe02h0oooo103om@1:000Io`@0ooD0AP3oool60?oe02`001Wo103om@0;0?ooo`<00?nc
2P3oool000T0oooo0`00ok<a0?ooo`H0ooD0E@006Ol40?oe02h0oooo103om@1:000Io`@0ooD0A`3o
ool70?oe02X001Wo103om@0;0?ooo`<00?nc2P3oool000T0oooo0`00ok<b0?ooo`H0ooD0E0006Ol4
0?oe02h0oooo103om@1:000Io`@0ooD0B@3oool60?oe02T001Wo103om@0;0?ooo`<00?nc2P3oool0
00T0oooo0`00ok<c0?ooo`H0ooD0D`006Ol40?oe02h0oooo103om@1:000Io`@0ooD0BP3oool70?oe
02L001Wo103om@0;0?ooo`<00?nc2P3oool000T0oooo0`00ok<e0?ooo`D0ooD0DP006Ol40?oe02h0
oooo103om@1:000Io`@0ooD0C03oool60?oe02H001Wo103om@0;0?ooo`<00?nc2P3oool000T0oooo
0`00ok<e0?ooo`H0ooD0D@006Ol40?oe02h0oooo103om@1:000Io`@0ooD0C@3oool70?oe02@001Wo
103om@0;0?ooo`<00?nc2P3oool000T0oooo0`00ok<f0?ooo`H0ooD0D0006Ol40?oe02h0oooo103o
m@1:000Io`@0ooD0C`3oool70?oe028001Wo103om@0;0?ooo`<00?nc2P3oool000T0oooo0`00ok<g
0?ooo`H0ooD0C`006Ol40?oe02h0oooo1@3om@19000Io`@0ooD0D03oool70?oe024001Wo103om@0;
0?ooo`<00?nc2P3oool000T0oooo0`00ok<h0?ooo`H0ooD0CP006Ol40?oe02l0oooo103om@19000I
o`D0ooD0D@3oool60?oe01l001Wo1@3om@0;0?ooo`<00?nc2P3oool000T0oooo0`00ok<i0?ooo`H0
ooD0C0006Ol50?oe02l0oooo103om@1:000Io`@0ooD0D`3oool50?oe01d001Wo1P3om@0;0?ooo`<0
0?nc2P3oool000T0oooo0`00ok<j0?ooo`H0ooD0B`006Ol50?oe02l0oooo103om@1:000Io`@0ooD0
D`3oool60?oe01/001Wo1P3om@0<0?ooo`<00?nc2P3oool000T0oooo0`00ok<k0?ooo`H0ooD0BP00
6Ol40?oe0300oooo103om@1:000Io`@0ooD0E03oool70?oe01P001Wo1P3om@0=0?ooo`<00?nc2P3o
ool000T0oooo0`00ok<l0?ooo`H0ooD0B@006Ol40?oe0300oooo103om@1:000Io`@0ooD0E@3oool9
0?oe018001Wo203om@0>0?ooo`<00?nc2P3oool000T0oooo0`00ok<m0?ooo`H0ooD0B0006Ol40?oe
0300oooo103om@1;000Io`@0ooD0E@3oool;0?oe00d001Wo2@3om@0?0?ooo`<00?nc2P3oool000T0
oooo0`00ok<n0?ooo`H0ooD0A`006Ol40?oe0300oooo103om@1;000Io`@0ooD0EP3oool=0?oe00P0
01Wo2P3om@0@0?ooo`<00?nc2P3oool000T0oooo0`00ok<o0?ooo`H0ooD0AP006Ol40?oe0300oooo
103om@1<000Io`@0ooD0F03ooolJ0?oe0180oooo0`00ok<:0?ooo`002@3oool3003o/d00oooo1P3o
m@14000Io`@0ooD0<@3oool40?oe04`001Wo103om@1K0?oooaD0ooD0503oool3003o/`X0oooo0009
0?ooo`<00?nc@@3oool70?oe048001Wo103om@0a0?ooo`@0ooD0C@006Ol40?oe05d0oooo403om@0F
0?ooo`<00?nc2P3oool000T0oooo0`00ok=20?ooo`P0ooD0?`006Ol40?oe0380oooo1@3om@1<000I
o`@0ooD0H03oool:0?oe01T0oooo0`00ok<:0?ooo`002@3oool3003o/d<0oooo2@3om@0l000Io`D0
ooD0<`3oool40?oe04`001Wo103om@230?ooo`<00?nc2P3oool000T0oooo0`00ok=40?ooo`T0ooD0
>P006Ol50?oe03@0oooo103om@1<000Io`@0ooD0P`3oool3003o/`X0oooo00090?ooo`<00?ncAP3o
ool80?oe03P001Wo1@3om@0e0?ooo`@0ooD0C@006Ol40?oe0880oooo0`00ok<:0?ooo`002@3oool3
003o/dP0oooo1`3om@0f000Io`H0ooD0=@3oool50?oe04`001Wo103om@220?ooo`<00?nc2P3oool0
00T0oooo0`00ok=:0?ooo`L0ooD0<`006Ol60?oe03L0oooo103om@1=000Io`@0ooD0P@3oool3003o
/`X0oooo00090?ooo`<00?ncB`3oool80?oe030001Wo1P3om@0h0?ooo`@0ooD0C@006Ol50?oe0800
oooo0`00ok<:0?ooo`002@3oool3003o/d`0oooo2P3om@0V000Io``0ooD0>@3oool50?oe04d001Wo
103om@200?ooo`<00?nc2P3oool000T0oooo0`00ok==0?ooo``0ooD07`006Ol?0?oe03/0oooo103o
m@1=000Io`@0ooD0P03oool3003o/`X0oooo00090?ooo`<00?ncC`3ooolF0?oe00L001Wo6P3om@0l
0?ooo`@0ooD0C@006Ol40?oe0800oooo0`00ok<:0?ooo`002@3oool3003o/e80oooo<P3om@0n0?oo
o`@0ooD0C@006Ol40?oe0800oooo0`00ok<:0?ooo`002@3oool3003o/eD0oooo:03om@150?ooo`@0
ooD0C@006Ol40?oe0800oooo0`00ok<:0?ooo`002@3oool3003o/eP0oooo8@3om@1:0?ooo`@0ooD0
C0006Ol40?oe0800oooo0`00ok<:0?ooo`002@3oool3003o/f@0oooo2@3om@1F0?ooo`@0ooD0C000
6Ol40?oe0800oooo0`00ok<:0?ooo`002@3oool3003o/l@0oooo103om@1;000Io`@0ooD0P03oool3
003o/`X0oooo00090?ooo`<00?nca03oool50?oe04X001Wo103om@200?ooo`<00?nc2P3oool000T0
oooo0`00ok?50?ooo`D0ooD0B@006Ol40?oe0800oooo0`00ok<:0?ooo`002@3oool3003o/lH0oooo
1@3om@18000Io`@0ooD0P03oool3003o/`X0oooo00090?ooo`<00?ncaP3oool60?oe04L001Wo103o
m@200?ooo`<00?nc2P3oool000T0oooo0`00ok?70?ooo`D0ooD0A`006Ol40?oe0800oooo0`00ok<:
0?ooo`002@3oool3003o/lP0oooo1@3om@16000Io`@0ooD0P03oool3003o/`X0oooo00090?ooo`<0
0?ncb@3oool50?oe04D001Wo103om@200?ooo`<00?nc2P3oool000T0oooo0`00ok?90?ooo`H0ooD0
A0006Ol40?oe0800oooo0`00ok<:0?ooo`002@3oool3003o/lX0oooo1P3om@13000Io`@0ooD0P03o
ool3003o/`X0oooo00090?ooo`<00?ncb`3oool60?oe044001Wo1@3om@200?ooo`<00?nc2P3oool0
00T0oooo0`00ok?<0?ooo`H0ooD0@0006Ol40?oe0840oooo0`00ok<:0?ooo`002@3oool3003o/ld0
oooo1`3om@0m000Io`@0ooD0PP3oool3003o/`X0oooo00090?ooo`<00?nccP3oool80?oe03/001Wo
103om@220?ooo`<00?nc2P3oool000T0oooo0`00ok?>0?ooo``0ooD0<P006Ol80?oe08<0oooo0`00
ok<:0?ooo`002@3oool3003o/m00oooo3@3om@0[000Io``0ooD0P`3oool3003o/`X0oooo00090?oo
o`<00?ncdP3oool=0?oe02@001Wo403om@240?ooo`<00?nc2P3oool000T0oooo0`00ok?E0?ooo`d0
ooD07@006OlC0?oe08D0oooo0`00ok<:0?ooo`002@3oool3003o/mP0oooo3P3om@0C000Ioa@0ooD0
RP3oool3003o/`X0oooo00090?ooo`<00?ncf`3oool^0?oe08h0oooo0`00ok<:0?ooo`002@3oool3
003o/mh0oooo9P3om@2C0?ooo`<00?nc2P3oool000T0oooo0`00ok?Q0?oooal0ooD0U`3oool3003o
/`X0oooo00090?ooo`<00?nci@3ooolE0?oe09d0oooo0`00ok<:0?ooo`002@3oool3003o/ol0oooo
V03oool3003o/`X0oooo00090?ooo`<00?nco`3ooonH0?ooo`<00?nc2P3oool000T0oooo0`00ok?o
0?oooiP0oooo0`00ok<:0?ooo`002@3oool3003o/ol0ooooV03oool3003o/`X0oooo00090?ooo`<0
0?nco`3ooonH0?ooo`<00?nc2P3oool000T0oooo0`00ok?o0?oooiP0oooo0`00ok<:0?ooo`002@3o
ool3003o/ol0ooooV03oool3003o/`X0oooo00090?ooo`<00?nco`3ooonH0?ooo`<00?nc2P3oool0
00T0oooo0`00ok?o0?oooiP0oooo0`00ok<:0?ooo`002@3oool3003o/ol0ooooV03oool3003o/`X0
oooo00090?ooo`<00?nco`3ooonH0?ooo`<00?nc2P3oool000T0oooo0`00ok?o0?oooiP0oooo0`00
ok<:0?ooo`002@3oool3003o/ol0ooooV03oool3003o/`X0oooo00090?ooo`<00?nco`3ooonH0?oo
o`<00?nc2P3oool000T0oooo0`00ok?o0?oooiP0oooo0`00ok<:0?ooo`002@3oool3003o/ol0oooo
V03oool3003o/`X0oooo00090?ooo`<00?nco`3ooonH0?ooo`<00?nc2P3oool000T0oooo0`00ok?o
0?oooiP0oooo0`00ok<:0?ooo`002@3oool3003o/ol0ooooV03oool3003o/`X0oooo00090?ooo`<0
0?nco`3ooonH0?ooo`<00?nc2P3oool000T0oooo0`00ok?o0?oooiP0oooo0`00ok<:0?ooo`002@3o
ool3003o/ol0ooooV03oool3003o/`X0oooo00090?ooo`<00?nco`3ooonH0?ooo`<00?nc2P3oool0
00T0oooo0`00ok?o0?oooiP0oooo0`00ok<:0?ooo`002@3oool3003o/ol0ooooV03oool3003o/`X0
oooo00090?ooo`<00?nco`3ooonH0?ooo`<00?nc2P3oool000T0oooo0`00ok?o0?oooiP0oooo0`00
ok<:0?ooo`002@3ooooo003o/ih00?nc2P3oool000T0ooooo`00ok>N003o/`X0oooo00090?ooool0
0?ncWP00ok<:0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?oo
o`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?oo
o`00\
\>"],
  ImageRangeCache->{{{0, 431}, {431, 0}} -> {-0.0250052, -0.0250052, \
0.00365433, 0.00365433}}],

Cell["\<\
c) Ahora viene tu trabajo. Debes calcular el \[AAcute]rea del lago que has \
dibujado usando integrales de l\[IAcute]nea. Observa que las orillas del lago \
son realmente una l\[IAcute]nea poligonal cuyos v\[EAcute]rtices son los \
puntos de la lista \"vertices\". 
c1) Define la funci\[OAcute]n que representa el segmento que une el punto \
\"vertices[[j]]\" con el punto \"vertices[[j+1]]\". 
c2) Calcula las integrales de l\[IAcute]nea de una conveniente \
funci\[OAcute]n a lo largo de cada segmento de la poligonal y suma los \
resultados para calcular el \[AAcute]rea del lago (muestra en pantalla \
solamente el resultado final).\
\>", "ExerciseText"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.2 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 685}},
WindowSize->{1016, 635},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{1, 2},
PageHeaders->{{Cell[ 
        TextData[ 
        "F. Javier P\[EAcute]rez Gonz\[AAcute]lez\nDpto. An\[AAcute]lisis \
Matem\[AAcute]tico - Universidad de Granada"], "Header"], Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"], Cell[ 
        TextData[ "Integrales de l\[IAcute]nea. Campos conservativos"], 
        "Header"]}, {Cell[ 
        TextData[ 
        "F. Javier P\[EAcute]rez Gonz\[AAcute]lez\nDpto. An\[AAcute]lisis \
Matem\[AAcute]tico - Universidad de Granada"], "Header"], Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"], Cell[ 
        TextData[ "Integrales de l\[IAcute]nea. Campos conservativos"], 
        "Header"]}},
PrintingOptions->{"FirstPageHeader"->False,
"FacingPages"->True},
Magnification->1.5,
StyleDefinitions -> "Classroom.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 66, 0, 99, "Title"],
Cell[1823, 53, 189, 7, 130, "Author"],

Cell[CellGroupData[{
Cell[2037, 64, 69, 0, 93, "Section"],

Cell[CellGroupData[{
Cell[2131, 68, 31, 0, 68, "Exercise"],
Cell[2165, 70, 613, 9, 153, "ExerciseText"],

Cell[CellGroupData[{
Cell[2803, 83, 495, 8, 202, "Input"],
Cell[3301, 93, 76, 1, 87, "Output"]
}, Open  ]],
Cell[3392, 97, 683, 12, 145, "ExerciseText"],
Cell[4078, 111, 1597, 51, 237, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5712, 167, 31, 0, 68, "Exercise"],
Cell[5746, 169, 401, 8, 93, "ExerciseText"],
Cell[6150, 179, 2436, 77, 177, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8623, 261, 31, 0, 68, "Exercise"],
Cell[8657, 263, 1762, 39, 313, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10456, 307, 31, 0, 68, "Exercise"],
Cell[10490, 309, 952, 18, 213, "ExerciseText"],
Cell[11445, 329, 1133, 22, 385, "Input"],
Cell[12581, 353, 2489, 70, 237, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[15107, 428, 31, 0, 68, "Exercise"],
Cell[15141, 430, 2881, 68, 545, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[18059, 503, 31, 0, 68, "Exercise"],
Cell[18093, 505, 2534, 72, 238, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[20664, 582, 31, 0, 68, "Exercise"],
Cell[20698, 584, 264, 5, 101, "ExerciseText"],
Cell[20965, 591, 247, 5, 150, "Input"],
Cell[21215, 598, 1674, 26, 335, "ExerciseText"],
Cell[22892, 626, 617, 11, 202, "Input"],
Cell[23512, 639, 56, 0, 41, "ExerciseText"],
Cell[23571, 641, 44960, 1141, 444, 11264, 720, "GraphicsData", "PostScript", \
"Graphics"],
Cell[68534, 1784, 668, 11, 161, "ExerciseText"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

